/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode.mock;

import java.io.PrintWriter;
import java.util.List;

public class IndentWriter {
    protected final PrintWriter pw;
    private final String indentWith;
    protected final String ind;
    private boolean lineStart = true;

    public IndentWriter(PrintWriter pw) {
        this(pw, "  ");
    }

    public IndentWriter(PrintWriter pw, String indentWith) {
        this.pw = pw;
        this.ind = "";
        this.indentWith = indentWith;
    }

    protected IndentWriter(PrintWriter pw, String ind, String indentWith) {
        this.pw = pw;
        this.ind = ind + indentWith;
        this.indentWith = indentWith;
    }

    public IndentWriter indent() {
        return new IndentWriter(this.pw, this.ind, this.indentWith);
    }

    public void print(String string) {
        if (this.lineStart) {
            this.pw.print(this.ind);
        }
        this.pw.print(string);
        this.pw.flush();
        this.lineStart = false;
    }

    public void println(String string) {
        if (this.lineStart && string.length() > 0) {
            this.pw.print(this.ind);
        }
        this.pw.print(string);
        this.pw.println();
        this.pw.flush();
        this.lineStart = true;
    }

    public void list(List<String> contents) {
        for (String s : contents) {
            this.println(s);
        }
    }

    public void newline() {
        this.lineStart = true;
    }
}

