/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode.mock;

import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.FieldExpr;
import org.zinutils.bytecode.IFieldInfo;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.bytecode.mock.MethodStreamer;
import org.zinutils.bytecode.mock.StreamFieldInfo;
import org.zinutils.exceptions.NotImplementedException;

public class ClassStreamer
implements ByteCodeSink {
    private final List<String> contents = new ArrayList<String>();
    private final List<MethodStreamer> methods = new ArrayList<MethodStreamer>();
    private String clzName;

    public ClassStreamer(String name) {
        this.clzName = name;
    }

    @Override
    public void version(int vno) {
    }

    @Override
    public String getCreatedName() {
        return this.clzName;
    }

    @Override
    public void superclass(String string) {
        this.contents.add("super: " + string);
    }

    @Override
    public IFieldInfo defineField(boolean isFinal, JavaInfo.Access access, JavaType type, String name) {
        this.contents.add("field " + (isFinal ? "final " : "") + access + " " + type + " " + name);
        return new StreamFieldInfo();
    }

    @Override
    public void inheritsField(boolean isFinal, JavaInfo.Access access, String ofType, String name) {
        this.contents.add("inhfield " + (isFinal ? "final " : "") + access + " " + ofType + " " + name);
    }

    @Override
    public void addInnerClassReference(JavaInfo.Access access, String parentClass, String inner) {
        this.contents.add("innerClz " + access + " " + parentClass + " " + inner);
    }

    @Override
    public byte[] generate() {
        throw new NotImplementedException();
    }

    @Override
    public String getSuperClass() {
        throw new NotImplementedException();
    }

    @Override
    public IFieldInfo defineField(boolean isFinal, JavaInfo.Access access, String type, String name) {
        throw new NotImplementedException();
    }

    @Override
    public void inheritsClass(String clz) {
        throw new NotImplementedException();
    }

    @Override
    public void inheritsField(boolean isFinal, JavaInfo.Access access, JavaType ofType, String name) {
        throw new NotImplementedException();
    }

    @Override
    public FieldExpr getField(NewMethodDefiner meth, String name) {
        throw new NotImplementedException();
    }

    @Override
    public FieldExpr getField(NewMethodDefiner meth, Expr on, String name) {
        throw new NotImplementedException();
    }

    @Override
    public void makeAbstract() {
        throw new NotImplementedException();
    }

    @Override
    public void makeInterface() {
        throw new NotImplementedException();
    }

    @Override
    public void implementsInterface(String intf) {
        throw new NotImplementedException();
    }

    @Override
    public void signatureAttribute(String name, String sig) {
        throw new NotImplementedException();
    }

    @Override
    public void addAttribute(String name, byte[] data) {
        throw new NotImplementedException();
    }

    @Override
    public Annotation addRTVAnnotation(String attrClass) {
        throw new NotImplementedException();
    }

    @Override
    public Annotation newAnnotation(String attrClass) {
        throw new NotImplementedException();
    }

    @Override
    public void addClassReference(JavaInfo.Access access, String inside, String enclosing, String refer) {
        throw new NotImplementedException();
    }

    @Override
    public void enclosingMethod(String createdName, NewMethodDefiner method) {
        throw new NotImplementedException();
    }

    @Override
    public MethodDefiner createMethod(boolean isStatic, String returnType, String name) {
        MethodStreamer ret = new MethodStreamer(this.clzName, isStatic, returnType, name);
        this.methods.add(ret);
        return ret;
    }

    @Override
    public void generateAssociatedSourceFile() {
    }

    public void dump(IndentWriter pw) {
        pw.list(this.contents);
        for (MethodStreamer m : this.methods) {
            m.dump(pw);
        }
    }
}

