/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode.mock;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.bytecode.ByteCodeStorage;
import org.zinutils.bytecode.mock.ClassStreamer;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.bytecode.mock.ShowDiff;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.utils.FileUtils;

public class ByteCodeStreamer
implements ByteCodeStorage {
    private Map<String, ClassStreamer> all = new TreeMap<String, ClassStreamer>();
    private Set<String> expected = new TreeSet<String>();

    @Override
    public ByteCodeSink newClass(String name) {
        ClassStreamer ret = new ClassStreamer(name);
        this.all.put(name, ret);
        return ret;
    }

    @Override
    public ByteCodeSink getOrCreate(String name) {
        throw new NotImplementedException();
    }

    @Override
    public boolean hasClass(String name) {
        throw new NotImplementedException();
    }

    @Override
    public ByteCodeSink get(String name) {
        throw new NotImplementedException();
    }

    public void dump() {
        this.dump(new PrintWriter(System.out));
    }

    private void dump(PrintWriter w) {
        IndentWriter pw = new IndentWriter(w);
        for (Map.Entry<String, ClassStreamer> x : this.all.entrySet()) {
            pw.println("class " + x.getKey());
            x.getValue().dump(pw.indent());
        }
    }

    public void validate() {
        TreeSet<String> unproc = new TreeSet<String>(this.all.keySet());
        unproc.removeAll(this.expected);
        if (!unproc.isEmpty()) {
            throw new RuntimeException("Classes were defined which weren't expected: " + this.all.keySet());
        }
    }

    public void expect(String name, String resource) {
        this.expected.add(name);
        if (!this.all.containsKey(name)) {
            throw new RuntimeException("There is no class " + name);
        }
        StringWriter sw = new StringWriter();
        this.dump(new PrintWriter(sw));
        String golden = FileUtils.readResource(resource);
        if (!golden.equals(sw.toString())) {
            List<String> exp = Arrays.asList(golden.split("\n"));
            List<String> actual = Arrays.asList(sw.toString().split("\n"));
            new ShowDiff(exp, actual).process();
            throw new RuntimeException("Did not match");
        }
    }
}

