/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.Justification;

public class VoidExpr
extends Expr {
    private final Expr expr;

    public VoidExpr(MethodDefiner meth, Expr ignoredResult) {
        super(meth);
        this.expr = ignoredResult;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        this.expr.spitOutByteCode(meth);
        meth.pop(this.expr.getType());
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        boolean ret = false;
        if (!suppressFirst) {
            sb.append(Justification.LEFT.format("", ind));
        }
        sb.append("(void)");
        this.expr.asSource(sb, lnt, ind, true);
        sb.append("\n");
        lnt.advance(1);
    }

    @Override
    public String getType() {
        throw new UtilException("This is void, which might, in some cases, be valid, but I haven't seen one yet");
    }
}

