/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.exceptions.UtilException;

public interface Var
extends IExpr {
    public Var setArgument(int var1);

    public void store();

    public static class DVar
    extends BaseVar {
        public DVar(MethodDefiner meth, String clz, String name) {
            super(meth, clz, name);
            meth.nextLocal();
        }

        private DVar(MethodDefiner meth) {
            super(meth, 0, "this");
            meth.nextLocal();
        }

        @Override
        public void spitOutByteCode(MethodDefiner meth) {
            meth.dload(this.id);
        }

        @Override
        public void store() {
            this.meth.dstore(this.id);
        }
    }

    public static class LVar
    extends BaseVar {
        public LVar(MethodDefiner meth, String clz, String name) {
            super(meth, clz, name);
            meth.nextLocal();
        }

        private LVar(MethodDefiner meth) {
            super(meth, 0, "this");
            meth.nextLocal();
        }

        @Override
        public void spitOutByteCode(MethodDefiner meth) {
            meth.lload(this.id);
        }

        @Override
        public void store() {
            this.meth.lstore(this.id);
        }
    }

    public static class IVar
    extends BaseVar {
        public IVar(MethodDefiner meth, String clz, String name) {
            super(meth, clz, name);
        }

        private IVar(MethodDefiner meth) {
            super(meth, 0, "this");
        }

        @Override
        public void spitOutByteCode(MethodDefiner meth) {
            meth.iload(this.id);
        }

        @Override
        public void store() {
            this.meth.istore(this.id);
        }
    }

    public static class AVar
    extends BaseVar {
        public AVar(MethodDefiner meth, String clz, String name) {
            super(meth, clz, name);
        }

        public AVar(MethodDefiner meth, JavaType clz, String name) {
            super(meth, clz, name);
        }

        private AVar(MethodDefiner meth) {
            super(meth, 0, "this");
        }

        public static AVar myThis(MethodDefiner meth) {
            return new AVar(meth);
        }

        @Override
        public void spitOutByteCode(MethodDefiner meth) {
            meth.aload(this.id);
        }

        @Override
        public void store() {
            this.meth.astore(this.id);
        }
    }

    public static abstract class BaseVar
    extends Expr
    implements Var {
        protected final int id;
        protected final String clz;
        private final String name;
        private int argpos = -1;

        protected BaseVar(MethodDefiner meth, String clz, String name) {
            super(meth);
            this.name = name;
            this.id = meth.nextLocal();
            this.clz = clz;
        }

        protected BaseVar(MethodDefiner meth, JavaType clz, String name) {
            super(meth);
            this.name = name;
            this.id = meth.nextLocal();
            this.clz = clz.getActual();
        }

        protected BaseVar(MethodDefiner meth, int id, String name) {
            super(meth);
            this.name = name;
            this.clz = meth.getClassName();
            this.id = id;
        }

        public int getLocalId() {
            return this.id;
        }

        @Override
        public String getType() {
            return this.clz;
        }

        @Override
        public Var setArgument(int i) {
            this.argpos = i;
            return this;
        }

        public int argPos() {
            if (this.argpos == -1) {
                throw new UtilException("It was not an argument");
            }
            return this.argpos;
        }

        @Override
        public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
            sb.append(this.name);
        }

        public String toString() {
            return this.clz + " " + this.name;
        }
    }
}

