/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.Marker;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.Var;

public class UnboxExpr
extends Expr {
    private final Expr expr;
    private final String outType;
    private final String convMethod;
    private final boolean protectFromNulls;

    public UnboxExpr(MethodCreator meth, Expr expr, boolean protectFromNulls) {
        super(meth);
        this.expr = expr;
        this.protectFromNulls = protectFromNulls;
        if (expr.getType().equals("java.lang.Boolean")) {
            this.outType = "boolean";
            this.convMethod = "booleanValue";
        } else if (expr.getType().equals("java.lang.Double")) {
            this.outType = "double";
            this.convMethod = "doubleValue";
        } else if (expr.getType().equals("java.lang.Integer")) {
            this.outType = "int";
            this.convMethod = "intValue";
        } else if (expr.getType().equals("java.lang.Long")) {
            this.outType = "long";
            this.convMethod = "longValue";
        } else {
            this.outType = null;
            this.convMethod = null;
        }
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        this.expr.spitOutByteCode(meth);
        if (this.outType != null) {
            if (this.protectFromNulls) {
                Var v = meth.varOfType(this.expr.getType(), "unbox");
                v.store();
                v.spitOutByteCode(meth);
                Marker doRet = meth.ifnonnull();
                if (this.outType.equals("int") || this.outType.equals("boolean")) {
                    meth.iconst(0);
                    meth.ireturn();
                } else if (this.outType.equals("long")) {
                    meth.lconst(0L);
                    meth.lreturn();
                } else if (this.outType.equals("double")) {
                    meth.dconst(0.0);
                    meth.dreturn();
                }
                doRet.setHere();
                v.spitOutByteCode(meth);
            }
            meth.invokeVirtualMethod(this.expr.getType(), this.outType, this.convMethod, new String[0]);
        }
    }

    @Override
    public String getType() {
        if (this.outType == null) {
            return this.expr.getType();
        }
        return this.outType;
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        this.expr.asSource(sb, lnt, ind, false);
    }
}

