/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.Marker;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.StackMapFrame;
import org.zinutils.bytecode.Var;
import org.zinutils.utils.Justification;

public class TryCatch
extends Expr {
    private final Expr inBlock;
    private final Expr handlerBlock;
    private final String exType;

    public TryCatch(MethodCreator meth, Expr inBlock, String exType, Expr handlerBlock) {
        super(meth);
        this.inBlock = inBlock;
        this.exType = exType;
        this.handlerBlock = handlerBlock;
    }

    @Override
    public void spitOutByteCode(MethodDefiner md) {
        MethodCreator meth = (MethodCreator)md;
        Marker m = meth.marker();
        this.inBlock.flush();
        Marker q = meth.marker();
        Marker r = meth.jump();
        meth.opstack(1);
        Marker s = meth.marker();
        Var ex = md.avar(this.exType, "ex");
        ex.store();
        this.handlerBlock.flush();
        r.setHere();
        meth.addException(this.exType, m, q, s);
        meth.addStackMapFrame(StackMapFrame.SAME_LOCALS_1_STACK_ITEM, s, this.exType);
        meth.addStackMapFrame(StackMapFrame.SAME_FRAME, meth.marker(), new String[0]);
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        if (ind > 0 && !suppressFirst) {
            sb.append(Justification.LEFT.format("", ind));
        }
        sb.append(this.toString());
        if (ind > 0 && !suppressFirst) {
            sb.append("\n");
            lnt.advance(1);
        }
    }

    @Override
    public String getType() {
        return this.inBlock.getType();
    }
}

