/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;

public class StringConstExpr
extends Expr {
    private final String str;

    public StringConstExpr(MethodDefiner meth, String str) {
        super(meth);
        if (str == null) {
            throw new NullPointerException("Cannot have a null string: use aNull");
        }
        this.str = str;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        meth.ldcString(this.str);
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        sb.append('\"');
        sb.append(this.str);
        sb.append('\"');
    }

    @Override
    public String getType() {
        return "java.lang.String";
    }
}

