/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.PCExpr;
import org.zinutils.bytecode.SourceCodeCreator;

public class SourceCodeMethodCreator {
    private final SourceCodeCreator parent;
    private final MethodCreator meth;
    private LineNumberTable lineNumberTable;

    public SourceCodeMethodCreator(SourceCodeCreator scc, MethodCreator m) {
        this.parent = scc;
        this.meth = m;
    }

    public String getName() {
        return this.meth.getName();
    }

    public int argCount() {
        return this.meth.argCount();
    }

    public int generate(StringBuilder sb, int lineNo) {
        this.lineNumberTable = new LineNumberTable(lineNo);
        sb.append("  ");
        if (this.meth.isAbstract()) {
            sb.append("abstract ");
        }
        if (this.meth.isStatic()) {
            sb.append("static ");
        }
        sb.append(this.meth.getReturnType() + " " + this.meth.getName() + "(");
        for (int i = 0; i < this.meth.argCount(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.meth.getArgument(i));
        }
        if (this.meth.exprs.isEmpty()) {
            this.lineNumberTable.add(0);
        }
        if (this.meth.isAbstract()) {
            sb.append(");\n");
        } else {
            sb.append(") {\n");
            this.lineNumberTable.advance(1);
            for (PCExpr e : this.meth.exprs) {
                this.lineNumberTable.add(e.from);
                e.expr.asSource(sb, this.lineNumberTable, 4, false);
            }
            sb.append("  }\n");
            this.lineNumberTable.advance(1);
        }
        return lineNo;
    }

    public void writelineNumberTable(DataOutputStream dos) throws IOException {
        this.parent.generate();
        this.lineNumberTable.write(dos);
    }
}

