/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.zinutils.bytecode.FieldInfo;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.SourceCodeMethodCreator;
import org.zinutils.utils.StringComparator;

public class SourceCodeCreator {
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private final List<SourceCodeMethodCreator> methods = new ArrayList<SourceCodeMethodCreator>();
    private final String sfile;
    private StringBuilder sb = null;
    private String supercl;
    private Set<String> interfaces = new TreeSet<String>(new StringComparator());

    public SourceCodeCreator(String sfile) {
        this.sfile = sfile;
    }

    public String getName() {
        return this.sfile;
    }

    public void addField(FieldInfo field) {
        this.fields.add(field);
    }

    public SourceCodeMethodCreator newMethod(MethodCreator m) {
        SourceCodeMethodCreator ret = new SourceCodeMethodCreator(this, m);
        this.methods.add(ret);
        return ret;
    }

    public void superclass(String scl) {
        this.supercl = scl;
    }

    public void implementsInterface(String intf) {
        this.interfaces.add(intf);
    }

    public void generate() {
        if (this.sb != null) {
            return;
        }
        this.sb = new StringBuilder();
        int lineNo = 1;
        this.sb.append("class " + this.sfile);
        if (this.supercl != null && !this.supercl.equals("java.lang.Object")) {
            this.sb.append(" extends " + this.supercl);
        }
        if (!this.interfaces.isEmpty()) {
            this.sb.append(" implements");
            String sep = " ";
            for (String i : this.interfaces) {
                this.sb.append(sep + i);
                sep = ", ";
            }
        }
        this.sb.append(" {\n");
        ++lineNo;
        for (FieldInfo f : this.fields) {
            this.sb.append("  ");
            this.sb.append(f.getSignature());
            this.sb.append(" ");
            this.sb.append(f.getName());
            this.sb.append("\n");
            ++lineNo;
        }
        if (!this.fields.isEmpty()) {
            this.sb.append("\n");
            ++lineNo;
        }
        for (SourceCodeMethodCreator ret : this.methods) {
            lineNo = ret.generate(this.sb, lineNo);
        }
        this.sb.append("}\n");
    }

    void writeTo(OutputStream os) throws IOException {
        this.generate();
        os.write(this.sb.toString().getBytes());
    }
}

