/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.AttributeInfo;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.exceptions.UtilException;

public class RuntimeVisibleAnnotations {
    private final List<Annotation> annotations = new ArrayList<Annotation>();

    public RuntimeVisibleAnnotations(ByteCodeFile bcf, AttributeInfo ai) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(ai.getBytes()));
            int cnt = dis.readUnsignedShort();
            for (int i = 0; i < cnt; ++i) {
                int nameIdx = dis.readUnsignedShort();
                Annotation annotation = new Annotation(bcf, ((CPInfo.Utf8Info)bcf.pool.get(nameIdx)).asString());
                this.annotations.add(annotation);
                int nargs = dis.readUnsignedShort();
                for (int j = 0; j < nargs; ++j) {
                    dis.readUnsignedShort();
                    dis.readByte();
                    dis.readUnsignedShort();
                }
            }
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public boolean has(String mapped) {
        for (Annotation a : this.annotations) {
            if (!a.name.equals(mapped)) continue;
            return true;
        }
        return false;
    }
}

