/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.Justification;

public class ReturnX
extends Expr {
    private final String retType;
    private final IExpr value;

    public ReturnX(MethodDefiner methodCreator, String retType, IExpr value) {
        super(methodCreator);
        this.retType = retType;
        this.value = value;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        if (this.retType.equals("void")) {
            meth.vreturn();
            return;
        }
        this.value.spitOutByteCode(meth);
        if (this.retType.equals("object")) {
            meth.areturn();
            return;
        }
        if (!this.retType.equals(this.value.getType())) {
            throw new UtilException("Mismatched argument types in return: " + this.retType + " and " + this.value.getType());
        }
        if (this.retType.equals("int") || this.retType.equals("boolean")) {
            meth.ireturn();
        } else if (this.retType.equals("long")) {
            meth.lreturn();
        } else if (this.retType.equals("double")) {
            meth.dreturn();
        } else {
            meth.areturn();
        }
    }

    @Override
    public String getType() {
        throw new UtilException("Don't ever use this as an argument");
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        sb.append(Justification.LEFT.format("", ind));
        sb.append("return");
        if (!this.retType.equals("void")) {
            sb.append(" ");
            this.value.asSource(sb, lnt, ind, true);
        }
        sb.append("\n");
        lnt.advance(1);
    }
}

