/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.Justification;

public class MethodInvocation
extends Expr {
    private final String type;
    private final String returns;
    private final Expr obj;
    private final String methodName;
    private final Expr[] args;
    private final String parentClzName;

    public MethodInvocation(MethodDefiner methodCreator, String type, String returns, Expr obj, String parentClzName, String methodName, Expr[] args) {
        super(methodCreator);
        this.type = type;
        this.returns = returns;
        this.obj = obj;
        if ((type.equals("interface") || type.equals("virtual")) && obj == null) {
            throw new UtilException("null object");
        }
        this.parentClzName = parentClzName;
        this.methodName = methodName;
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            throw new UtilException("null argument");
        }
    }

    public MethodInvocation(MethodDefiner methodCreator, String type, String returns, Expr obj, String parentClzName, String methodName, IExpr[] args) {
        super(methodCreator);
        this.type = type;
        this.returns = returns;
        this.obj = obj;
        if ((type.equals("interface") || type.equals("virtual")) && obj == null) {
            throw new UtilException("null object invoking " + methodName + " with " + args.length + " args");
        }
        this.parentClzName = parentClzName;
        this.methodName = methodName;
        this.args = new Expr[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                throw new UtilException("null argument");
            }
            this.args[i] = (Expr)args[i];
        }
    }

    public String name() {
        return this.methodName;
    }

    public IExpr target() {
        return this.obj;
    }

    public IExpr[] arguments() {
        return this.args;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        if (this.obj != null) {
            this.obj.spitOutByteCode(meth);
        }
        String[] argTypes = new String[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            Expr e = this.args[i];
            argTypes[i] = e.getType();
            e.spitOutByteCode(meth);
        }
        if (this.type.equals("virtual")) {
            meth.invokeVirtualMethod(this.obj.getType(), this.returns, this.methodName, argTypes);
        } else if (this.type.equals("interface")) {
            meth.invokeInterface(this.obj.getType(), this.returns, this.methodName, argTypes);
        } else if (this.type.equals("super")) {
            meth.invokeParentMethod(this.returns, this.methodName, argTypes);
        } else if (this.type.equals("static")) {
            meth.invokeStatic(this.parentClzName, this.returns, this.methodName, argTypes);
        } else {
            throw new UtilException("Can't handle method type " + this.type);
        }
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        boolean ret;
        boolean bl = ret = !suppressFirst;
        if (!suppressFirst) {
            sb.append(Justification.LEFT.format("", ind));
        }
        if (this.type.equals("virtual") || this.type.equals("interface")) {
            this.obj.asSource(sb, lnt, ind, true);
        } else if (this.type.equals("super")) {
            sb.append("super");
        } else if (this.type.equals("static")) {
            sb.append(this.parentClzName);
        } else {
            sb.append("??? " + this.type);
        }
        sb.append(".");
        sb.append(this.methodName);
        sb.append("(");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            this.args[i].asSource(sb, lnt, ind + 2, true);
        }
        sb.append(")");
        if (!suppressFirst) {
            sb.append("\n");
            lnt.advance(1);
        }
    }

    @Override
    public String getType() {
        return this.returns;
    }
}

