/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.AnnotationHolder;
import org.zinutils.bytecode.AnnotationType;
import org.zinutils.bytecode.AttributeInfo;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.collections.ListMap;

public class MethodInfo
extends JavaInfo
implements AnnotationHolder {
    protected short access_flags = (short)-1;
    protected short nameIdx = (short)-1;
    protected short descriptorIdx = (short)-1;
    protected final ByteCodeFile bcf;
    protected final List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
    private ListMap<AnnotationType, Annotation> annotations = new ListMap();

    public MethodInfo(ByteCodeFile bcf) {
        this.bcf = bcf;
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeShort(this.access_flags);
        dos.writeShort(this.nameIdx);
        dos.writeShort(this.descriptorIdx);
        this.bcf.writeAttributes(dos, this.attributes);
    }

    public String getName() {
        return ((CPInfo.Utf8Info)this.bcf.pool.get(this.nameIdx)).asString();
    }

    public String getSignature() {
        return ((CPInfo.Utf8Info)this.bcf.pool.get(this.descriptorIdx)).asString();
    }

    public String toString() {
        if (this.nameIdx != -1 && this.descriptorIdx != -1) {
            return "Method[" + this.bcf.pool.get(this.nameIdx) + this.bcf.pool.get(this.descriptorIdx) + "]";
        }
        return "Method[?,?]";
    }

    public AttributeInfo getAttribute(String string) {
        for (AttributeInfo ai : this.attributes) {
            if (!ai.hasName(string)) continue;
            return ai;
        }
        return null;
    }

    public Annotation getClassAnnotation(String ann) {
        for (AnnotationType i : this.annotations) {
            for (Annotation j : this.annotations.get(i)) {
                if (!j.name.equals(ann)) continue;
                return j;
            }
        }
        return null;
    }

    @Override
    public Annotation addAnnotation(AnnotationType type, Annotation ann) {
        this.annotations.add(type, ann);
        return ann;
    }

    public short getDescriptorIdx() {
        return this.descriptorIdx;
    }

    public void setSignature(String rw) {
        this.bcf.pool.setPoolEntry(this.descriptorIdx, new CPInfo.Utf8Info(rw));
    }

    public int getAccess() {
        return this.access_flags;
    }
}

