/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.AnnotationType;
import org.zinutils.bytecode.ArrayEltExpr;
import org.zinutils.bytecode.ArrayItem;
import org.zinutils.bytecode.ArrayLenExpr;
import org.zinutils.bytecode.ArrayOfExpr;
import org.zinutils.bytecode.AssignExpr;
import org.zinutils.bytecode.AttributeInfo;
import org.zinutils.bytecode.BlockExpr;
import org.zinutils.bytecode.BoolConstExpr;
import org.zinutils.bytecode.BoxExpr;
import org.zinutils.bytecode.ByteCodeCreator;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.CastToExpr;
import org.zinutils.bytecode.ClassConstExpr;
import org.zinutils.bytecode.ConcatExpr;
import org.zinutils.bytecode.DoubleConstExpr;
import org.zinutils.bytecode.EqualsExpr;
import org.zinutils.bytecode.ExceptionHandler;
import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.FieldExpr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.IfExpr;
import org.zinutils.bytecode.InstanceOf;
import org.zinutils.bytecode.Instruction;
import org.zinutils.bytecode.IntConstExpr;
import org.zinutils.bytecode.IsExpr;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.MakeNewExpr;
import org.zinutils.bytecode.Marker;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.MethodInfo;
import org.zinutils.bytecode.MethodInvocation;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.NullExpr;
import org.zinutils.bytecode.PCExpr;
import org.zinutils.bytecode.Remarker;
import org.zinutils.bytecode.RemarkerExpr;
import org.zinutils.bytecode.ReturnX;
import org.zinutils.bytecode.SourceCodeMethodCreator;
import org.zinutils.bytecode.StackMapFrame;
import org.zinutils.bytecode.StackMapFrameEntry;
import org.zinutils.bytecode.StringConstExpr;
import org.zinutils.bytecode.ThrowExpr;
import org.zinutils.bytecode.TryCatch;
import org.zinutils.bytecode.UnboxExpr;
import org.zinutils.bytecode.UseAsType;
import org.zinutils.bytecode.Var;
import org.zinutils.bytecode.VoidExpr;
import org.zinutils.collections.ListMap;
import org.zinutils.exceptions.UtilException;

public class MethodCreator
extends MethodInfo
implements MethodDefiner {
    private final List<Var> arguments = new ArrayList<Var>();
    private String returnType;
    protected final List<PCExpr> exprs = new ArrayList<PCExpr>();
    protected final List<Instruction> instructions = new ArrayList<Instruction>();
    private int opdepth = 0;
    protected int locals = 0;
    protected int maxStack = 0;
    protected boolean lenientMode = false;
    private final ByteCodeCreator byteCodeCreator;
    private final String name;
    private List<String> exceptions = new ArrayList<String>();
    private final ListMap<AnnotationType, Annotation> annotations = new ListMap(AnnotationType.sortOrder);
    private final boolean isStatic;
    private final List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();
    private SourceCodeMethodCreator scc;
    private byte[] smt;
    private List<StackMapFrameEntry> smfEntries = new ArrayList<StackMapFrameEntry>();

    public MethodCreator(ByteCodeCreator byteCodeCreator, ByteCodeFile bcf, boolean isStatic, String returnType, String name) {
        super(bcf);
        this.isStatic = isStatic;
        this.name = name;
        this.returnType = MethodCreator.map(returnType);
        this.byteCodeCreator = byteCodeCreator;
        this.nameIdx = bcf.pool.requireUtf8(name);
        if (!isStatic) {
            this.locals = 1;
        }
    }

    @Override
    public void setAccess(JavaInfo.Access a) {
        this.access_flags = a.asShort();
    }

    @Override
    public void makeFinal() {
        if (this.access_flags == -1) {
            this.setAccess(JavaInfo.Access.PUBLIC);
        }
        this.access_flags = (short)(this.access_flags | 0x10);
    }

    @Override
    public void makeBridge() {
        if (this.access_flags == -1) {
            this.setAccess(JavaInfo.Access.PUBLIC);
        }
        this.access_flags = (short)(this.access_flags | 0x1040);
    }

    @Override
    public void makeTransient() {
        if (this.access_flags == -1) {
            this.setAccess(JavaInfo.Access.PUBLIC);
        }
        this.access_flags = (short)(this.access_flags | 0x80);
    }

    public boolean isAbstract() {
        return this.instructions.size() == 0;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getReturnType() {
        return MethodCreator.unmap(this.returnType);
    }

    public void generateSource(SourceCodeMethodCreator scc) {
        this.scc = scc;
    }

    @Override
    public void addStackMapFrame(StackMapFrame type, Marker s, String ... vtypes) {
        for (StackMapFrameEntry x : this.smfEntries) {
            if (type != x.type || s.getLocation() != x.at.getLocation()) continue;
            return;
        }
        this.smfEntries.add(new StackMapFrameEntry(type, s, vtypes));
    }

    @Override
    public void stackMapTable(byte[] bs) {
        this.smt = bs;
    }

    @Override
    public void addAttribute(String named, String text) {
        short ptr = this.bcf.pool.requireUtf8(text);
        byte[] data = new byte[]{(byte)(ptr >> 8), (byte)(ptr & 0xFF)};
        this.addAttribute(named, data);
    }

    @Override
    public void addExpression(PCExpr expr) {
        this.exprs.add(expr);
    }

    @Override
    public void addAttribute(String named, byte[] data) {
        this.attributes.add(this.bcf.newAttribute(named, data));
    }

    @Override
    public void lenientMode(boolean mode) {
        if (mode) {
            System.err.println("Turning on lenient mode for " + this.bcf + " method " + this.name);
        }
        this.lenientMode = mode;
    }

    @Override
    public Var argument(String type, String aname) {
        Var ret = this.varOfType(type, aname);
        ret.setArgument(this.arguments.size());
        this.arguments.add(ret);
        return ret;
    }

    @Override
    public Var getArgument(int i) {
        return this.arguments.get(i);
    }

    @Override
    public Var varOfType(String type, String aname) {
        if (type.equals("int") || type.equals("boolean")) {
            return this.ivar(type, aname);
        }
        if (type.equals("long")) {
            return this.lvar(this.name);
        }
        if (type.equals("double")) {
            return this.dvar(aname);
        }
        return this.avar(type, aname);
    }

    @Override
    public Var.AVar myThis() {
        if (this.isStatic) {
            throw new UtilException("Static methods don't have 'this' (defining " + this.bcf.getName() + "." + this.name + ")");
        }
        return Var.AVar.myThis(this);
    }

    @Override
    public Var saveAslocal(String clz, String name) {
        Var ret = this.varOfType(clz, name);
        ret.store();
        return ret;
    }

    @Override
    public Var avar(JavaType clz, String name) {
        return new Var.AVar((MethodDefiner)this, clz, name);
    }

    @Override
    public Var avar(String clz, String name) {
        return new Var.AVar((MethodDefiner)this, clz, name);
    }

    @Override
    public Var ivar(String clz, String name) {
        return new Var.IVar((MethodDefiner)this, clz, name);
    }

    @Override
    public Var lvar(String name) {
        return new Var.LVar((MethodDefiner)this, "long", name);
    }

    @Override
    public Var dvar(String name) {
        return new Var.DVar((MethodDefiner)this, "double", name);
    }

    @Override
    public Expr aNull() {
        return new NullExpr(this);
    }

    @Override
    public int argCount() {
        return this.arguments.size();
    }

    @Override
    public FieldExpr getField(String name) {
        return this.byteCodeCreator.getField(this, name);
    }

    @Override
    public IExpr getField(IExpr on, String name) {
        return this.byteCodeCreator.getField(this, (Expr)on, name);
    }

    @Override
    public Expr staticField(String clz, String type, String named) {
        return new FieldExpr((NewMethodDefiner)this, null, clz, type, named);
    }

    @Override
    public Expr arrayItem(String returnType, Var array, int idx) {
        return new ArrayItem(this, returnType, array, idx);
    }

    @Override
    public IExpr as(IExpr expr, String newType) {
        return new UseAsType(this, expr, newType);
    }

    @Override
    public IExpr assign(Var assignTo, IExpr expr) {
        return new AssignExpr((MethodDefiner)this, assignTo, expr);
    }

    @Override
    public Expr assign(IExpr field, IExpr expr) {
        return new AssignExpr((MethodDefiner)this, field, (IExpr)((Expr)expr));
    }

    @Override
    public BoolConstExpr boolConst(boolean b) {
        return new BoolConstExpr(this, b);
    }

    @Override
    public IExpr box(IExpr expr) {
        return new BoxExpr(this, expr);
    }

    @Override
    public Expr unbox(Expr expr, boolean protectFromNulls) {
        return new UnboxExpr(this, expr, protectFromNulls);
    }

    @Override
    public IExpr block(IExpr ... exprs) {
        return new BlockExpr((NewMethodDefiner)this, exprs);
    }

    @Override
    public Expr callSuper(String returns, String parentClzName, String methodName, IExpr ... args) {
        return new MethodInvocation((MethodDefiner)this, "super", returns, (Expr)this.myThis(), parentClzName, methodName, this.repack(args));
    }

    private Expr[] repack(IExpr[] args) {
        if (args == null) {
            return null;
        }
        Expr[] ret = new Expr[args.length];
        for (int i = 0; i < args.length; ++i) {
            ret[i] = (Expr)args[i];
        }
        return ret;
    }

    @Override
    public IExpr callVirtual(String returns, IExpr obj, String methodName, IExpr ... args) {
        return new MethodInvocation((MethodDefiner)this, "virtual", returns, (Expr)obj, null, methodName, args);
    }

    @Override
    public IExpr callInterface(String returns, IExpr obj, String methodName, IExpr ... args) {
        return new MethodInvocation((MethodDefiner)this, "interface", returns, (Expr)obj, null, methodName, args);
    }

    @Override
    public Expr callStatic(String inClz, String returns, String methodName, IExpr ... args) {
        return new MethodInvocation((MethodDefiner)this, "static", returns, null, inClz, methodName, args);
    }

    @Override
    public Expr callStatic(String inClz, JavaType returns, String methodName, IExpr ... args) {
        return new MethodInvocation((MethodDefiner)this, "static", returns.getActual(), null, inClz, methodName, args);
    }

    @Override
    public IExpr castTo(IExpr expr, String ofType) {
        return new CastToExpr(this, expr, ofType);
    }

    @Override
    public ClassConstExpr classConst(String cls) {
        return new ClassConstExpr(this, cls);
    }

    @Override
    public Expr concat(Object ... args) {
        return new ConcatExpr(this, args);
    }

    @Override
    public IExpr ifBoolean(IExpr expr, IExpr then, IExpr orelse) {
        return new IfExpr((MethodDefiner)this, expr, true, then, orelse);
    }

    @Override
    public IExpr ifNotBoolean(IExpr expr, IExpr then, IExpr orelse) {
        return new IfExpr((MethodDefiner)this, expr, false, then, orelse);
    }

    @Override
    public IExpr ifEquals(IExpr left, IExpr right, IExpr then, IExpr orelse) {
        return new IfExpr((MethodDefiner)this, (IExpr)new EqualsExpr(this, left, right), true, then, orelse);
    }

    @Override
    public Expr ifNotNull(IExpr test, IExpr then, IExpr orelse) {
        return new IfExpr((MethodDefiner)this, test, then, orelse, IfExpr.IfCond.NOTNULL);
    }

    @Override
    public Expr ifNull(IExpr test, IExpr then, IExpr orelse) {
        return new IfExpr((MethodDefiner)this, test, then, orelse, IfExpr.IfCond.NULL);
    }

    @Override
    public IExpr ifOp(int opcode, IExpr lhs, IExpr rhs, IExpr then, IExpr orelse) {
        return new IfExpr(this, opcode, lhs, rhs, then, orelse);
    }

    @Override
    public Expr instanceOf(IExpr expr, String ofClz) {
        return new InstanceOf(this, expr, ofClz);
    }

    @Override
    public IntConstExpr intConst(int i) {
        return new IntConstExpr(this, i);
    }

    @Override
    public DoubleConstExpr doubleConst(double d) {
        return new DoubleConstExpr(this, d);
    }

    @Override
    public Expr isNull(Expr test, Expr yes, Expr no) {
        return new IsExpr(this, test, yes, no, IfExpr.IfCond.NULL);
    }

    @Override
    public Expr arrayOf(String clz, IExpr ... as) {
        ArrayList<IExpr> al = new ArrayList<IExpr>();
        for (IExpr a : as) {
            al.add(a);
        }
        return new ArrayOfExpr(this, clz, al);
    }

    @Override
    public Expr arrayOf(String clz, List<IExpr> al) {
        return new ArrayOfExpr(this, clz, al);
    }

    @Override
    public Expr arraylen(Expr expr) {
        return new ArrayLenExpr(this, expr);
    }

    @Override
    public Expr arrayElt(IExpr arr, IExpr elt) {
        return new ArrayEltExpr(this, arr, elt);
    }

    @Override
    public IExpr makeNew(String ofClz, IExpr ... args) {
        return new MakeNewExpr(this, ofClz, true, args);
    }

    @Override
    public IExpr makeNewVoid(String ofClz, IExpr ... args) {
        return new MakeNewExpr(this, ofClz, false, args);
    }

    @Override
    public Expr returnTyped(Expr e) {
        return new ReturnX(this, e.getType(), e);
    }

    @Override
    public Expr returnVoid() {
        return new ReturnX(this, "void", null);
    }

    @Override
    public IExpr returnBool(IExpr i) {
        return new ReturnX(this, "boolean", i);
    }

    @Override
    public IExpr returnInt(IExpr i) {
        return new ReturnX(this, "int", i);
    }

    @Override
    public Expr returnObject(IExpr e) {
        return new ReturnX(this, "object", (Expr)e);
    }

    @Override
    public StringConstExpr stringConst(String str) {
        return new StringConstExpr(this, str);
    }

    @Override
    public Expr throwException(String clz, Expr ... args) {
        return new ThrowExpr(this, clz, args);
    }

    @Override
    public TryCatch tryCatch(Expr inBlock, String exType, Expr andThen) {
        return new TryCatch(this, inBlock, exType, andThen);
    }

    @Override
    public IExpr trueConst() {
        return this.as(this.intConst(1), "boolean");
    }

    @Override
    public IExpr falseConst() {
        return this.as(this.intConst(0), "boolean");
    }

    @Override
    public Expr voidExpr(IExpr ignoredResult) {
        return new VoidExpr(this, (Expr)ignoredResult);
    }

    @Override
    public void throwsException(String exception) {
        this.exceptions.add(exception);
    }

    @Override
    public int currentPC() {
        int ret = 0;
        for (Instruction i : this.instructions) {
            ret += i.length();
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void complete() throws IOException {
        DataOutputStream dos;
        ByteArrayOutputStream baos;
        for (AttributeInfo a : this.attributes) {
            if (!a.hasName("Code")) continue;
            throw new UtilException("Cannot complete a method that already has a Code attribute");
        }
        if (this.access_flags == -1) {
            this.access_flags = 1;
        }
        if (this.isStatic) {
            this.access_flags = (short)(this.access_flags | 8);
        }
        for (AnnotationType at : this.annotations) {
            at.addTo(this.bcf, this.attributes, this.annotations.get(at), this.arguments.size());
        }
        if (this.exceptions.size() != 0) {
            try {
                baos = new ByteArrayOutputStream();
                dos = new DataOutputStream(baos);
                dos.writeShort(this.exceptions.size());
                for (String string : this.exceptions) {
                    dos.writeShort(this.bcf.pool.requireClass(string));
                }
                this.attributes.add(this.bcf.newAttribute("Exceptions", baos.toByteArray()));
            }
            catch (Exception ex) {
                throw UtilException.wrap(ex);
            }
        }
        if (!this.smfEntries.isEmpty()) {
            if (this.smt != null) {
                throw new UtilException("Cannot both add entries and set explicit SMF table");
            }
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            int prev = 0;
            dos.writeShort(this.smfEntries.size());
            for (StackMapFrameEntry x : this.smfEntries) {
                int offset;
                int loc = x.at.getLocation();
                if (prev == 0) {
                    offset = loc;
                } else {
                    if (loc <= prev) {
                        throw new UtilException("You need to get these in the right order; try to make them generate in the right order, otherwise sort here before building the table: " + loc + " <= " + prev);
                    }
                    offset = loc - prev - 1;
                }
                prev = loc;
                if (x.type == StackMapFrame.SAME_FRAME && offset < 64) {
                    dos.write(x.type.basic + offset);
                    continue;
                }
                if (x.type == StackMapFrame.SAME_FRAME) {
                    dos.write(251);
                    dos.writeShort(offset);
                    continue;
                }
                if (x.type == StackMapFrame.SAME_LOCALS_1_STACK_ITEM && offset < 64 && x.vtypes.length == 1) {
                    dos.write(x.type.basic + offset);
                    dos.write(7);
                    dos.writeShort(this.bcf.pool.requireClass(x.vtypes[0]));
                    continue;
                }
                if (x.type == StackMapFrame.SAME_FRAME_APPEND && x.vtypes.length < 3) {
                    dos.write(x.type.basic + x.vtypes.length - 1);
                    dos.writeShort(offset);
                    for (int q = 0; q < x.vtypes.length; ++q) {
                        dos.write(7);
                        dos.writeShort(this.bcf.pool.requireClass(x.vtypes[q]));
                    }
                    continue;
                }
                if (x.type == StackMapFrame.SAME_LOCALS_1_STACK_ITEM) {
                    dos.write(StackMapFrame.FULL_FRAME.basic);
                    dos.writeShort(offset);
                    dos.writeShort(0);
                    dos.writeShort(1);
                    dos.write(7);
                    dos.writeShort(this.bcf.pool.requireClass(x.vtypes[0]));
                    continue;
                }
                throw new UtilException("Cannot handle " + x.type + " with offset " + offset);
            }
            dos.flush();
            this.smt = baos.toByteArray();
        }
        if (this.instructions.size() == 0) {
            this.access_flags = (short)(this.access_flags | 0x400);
        } else {
            if (this.opdepth != 0) {
                if (this.lenientMode) {
                    System.err.println("Stack was left with depth " + this.opdepth + " after processing " + this.name + " for " + this.bcf);
                } else {
                    throw new UtilException("Stack was left with depth " + this.opdepth + " after processing " + this.name + " for " + this.bcf);
                }
            }
            if (this.instructions.size() > 0) {
                this.diminishLocals();
                int len = this.pclen();
                try {
                    void var4_15;
                    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                    DataOutputStream dos2 = new DataOutputStream(baos2);
                    dos2.writeShort(this.maxStack);
                    dos2.writeShort(this.locals);
                    dos2.writeInt(len);
                    for (Instruction i : this.instructions) {
                        i.write(dos2);
                    }
                    dos2.writeShort(this.exceptionHandlers.size());
                    for (ExceptionHandler eh : this.exceptionHandlers) {
                        eh.write(dos2);
                    }
                    boolean bl = false;
                    if (this.scc != null) {
                        void var4_14;
                        ++var4_14;
                    }
                    if (this.smt != null) {
                        ++var4_15;
                    }
                    dos2.writeShort((int)var4_15);
                    if (this.scc != null) {
                        dos2.writeShort(this.bcf.pool.requireUtf8("LineNumberTable"));
                        this.scc.writelineNumberTable(dos2);
                    }
                    if (this.smt != null) {
                        dos2.writeShort(this.bcf.pool.requireUtf8("StackMapTable"));
                        dos2.writeInt(this.smt.length);
                        dos2.write(this.smt);
                    }
                    this.attributes.add(this.bcf.newAttribute("Code", baos2.toByteArray()));
                }
                catch (Exception ex) {
                    throw UtilException.wrap(ex);
                }
            }
        }
        this.descriptorIdx = this.bcf.pool.requireUtf8(this.signature());
    }

    private int pclen() {
        int len = 0;
        for (Instruction i : this.instructions) {
            len += i.length();
        }
        return len;
    }

    private void diminishLocals() {
        this.locals = 0;
        if (!this.isStatic) {
            this.locals = 1;
        }
        this.locals += this.arguments.size();
        for (Instruction i : this.instructions) {
            int v = i.usesVar();
            if (v + 1 <= this.locals) continue;
            this.locals = v + 1;
        }
    }

    String signature() {
        ArrayList<String> mapto = new ArrayList<String>();
        for (Var v : this.arguments) {
            mapto.add(JavaInfo.map(v.getType()));
        }
        return MethodCreator.signature(this.returnType, mapto);
    }

    public static String signature(String ret, Iterable<String> args) {
        StringBuilder sb = new StringBuilder("(");
        for (String s : args) {
            sb.append(s);
        }
        sb.append(")");
        sb.append(ret);
        return sb.toString();
    }

    private int hi(int idx) {
        return idx >> 8 & 0xFF;
    }

    private int lo(int idx) {
        return idx & 0xFF;
    }

    private void add(int stackChange, Instruction instruction) {
        if (this.lenientMode) {
            System.err.println(this.pclen() + ": " + instruction + " stack = " + this.opdepth + " change = " + stackChange + " => " + (this.opdepth + stackChange));
        }
        this.instructions.add(instruction);
        this.opstack(stackChange);
    }

    public void opstack(int i) {
        this.opdepth += i;
        if (this.opdepth < 0 && !this.lenientMode) {
            throw new UtilException("Stack underflow generating " + this.name + " in " + this.bcf);
        }
        if (this.opdepth > this.maxStack) {
            this.maxStack = this.opdepth;
        }
    }

    @Override
    public void aconst_null() {
        this.add(1, new Instruction(1));
    }

    @Override
    public void aaload() {
        this.add(-1, new Instruction(50));
    }

    @Override
    public void aastore() {
        this.add(-3, new Instruction(83));
    }

    @Override
    public void aload(int i) {
        if (i < 4) {
            this.add(1, new Instruction(42 + i));
        } else {
            this.add(1, new Instruction(25, i));
        }
    }

    @Override
    public void anewarray(String clz) {
        int idx = this.bcf.pool.requireClass(clz);
        this.add(0, new Instruction(189, this.hi(idx), this.lo(idx)));
    }

    @Override
    public void areturn() {
        this.add(-1, new Instruction(176));
    }

    @Override
    public void astore(int i) {
        if (i < 4) {
            this.add(-1, new Instruction(75 + i));
        } else {
            this.add(-1, new Instruction(58, i));
        }
        if (i >= this.locals) {
            this.locals = i + 1;
        }
    }

    @Override
    public void athrow() {
        this.add(-1, new Instruction(191));
    }

    @Override
    public void checkCast(String clz) {
        int idx = this.bcf.pool.requireClass(JavaInfo.mapPrimitive(clz));
        this.add(0, new Instruction(192, idx >> 8, idx & 0xFF));
    }

    @Override
    public void dload(int i) {
        if (i < 4) {
            this.add(2, new Instruction(38 + i));
        } else {
            this.add(2, new Instruction(24, i));
        }
    }

    @Override
    public void dreturn() {
        this.add(-2, new Instruction(175));
    }

    @Override
    public void dstore(int i) {
        if (i < 4) {
            this.add(-2, new Instruction(71 + i));
        } else {
            this.add(-2, new Instruction(57, i));
        }
        if (i >= this.locals) {
            this.locals = i + 1;
        }
    }

    @Override
    public void dup() {
        this.add(1, new Instruction(89));
    }

    @Override
    public void getField(String clz, String type, String var) {
        int clzIdx = this.bcf.pool.requireClass(clz);
        short fieldIdx = this.bcf.pool.requireUtf8(var);
        short sigIdx = this.bcf.pool.requireUtf8(MethodCreator.map(type));
        int ntIdx = this.bcf.pool.requireNT(fieldIdx, sigIdx);
        int idx = this.bcf.pool.requireRef(9, clzIdx, ntIdx);
        this.add(0, new Instruction(180, this.hi(idx), this.lo(idx)));
    }

    @Override
    public void getStatic(String clz, String type, String var) {
        int clzIdx = this.bcf.pool.requireClass(clz);
        short fieldIdx = this.bcf.pool.requireUtf8(var);
        short sigIdx = this.bcf.pool.requireUtf8(MethodCreator.map(type));
        int ntIdx = this.bcf.pool.requireNT(fieldIdx, sigIdx);
        int idx = this.bcf.pool.requireRef(9, clzIdx, ntIdx);
        this.add(1, new Instruction(178, this.hi(idx), this.lo(idx)));
    }

    @Override
    public void dconst(double d) {
        if (d == 0.0 || d == 1.0) {
            int i = 14 + (int)d;
            this.add(2, new Instruction(i));
        } else {
            short idx = this.bcf.pool.requireDouble(d);
            this.add(2, new Instruction(20, this.hi(idx), this.lo(idx)));
        }
    }

    @Override
    public void iconst(int i) {
        if (i >= -1 && i <= 5) {
            this.add(1, new Instruction(i += 3));
        } else if (i >= -128 && i <= 127) {
            this.add(1, new Instruction(16, i & 0xFF));
        } else if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            this.add(1, new Instruction(17, i >> 8 & 0xFF, i & 0xFF));
        } else {
            short idx = this.bcf.pool.requireInteger(i);
            if (idx < 256) {
                this.add(1, new Instruction(18, idx));
            } else {
                this.add(1, new Instruction(19, this.hi(idx), this.lo(idx)));
            }
        }
    }

    @Override
    public void lconst(long l) {
        if (l >= 0L && l <= 1L) {
            this.add(2, new Instruction((int)(l += 9L)));
        } else {
            int idx = this.bcf.pool.requireLong(l);
            if (idx < 256) {
                this.add(1, new Instruction(18, idx));
            } else {
                this.add(1, new Instruction(19, this.hi(idx), this.lo(idx)));
            }
        }
    }

    @Override
    public Marker ifeq() {
        Marker ret = new Marker(this.instructions, 1);
        this.add(-1, new Instruction(153, 0, 0));
        return ret;
    }

    @Override
    public Marker ifne() {
        Marker ret = new Marker(this.instructions, 1);
        this.add(-1, new Instruction(154, 0, 0));
        return ret;
    }

    @Override
    public Marker iflt() {
        Marker ret = new Marker(this.instructions, 1);
        this.add(-1, new Instruction(155, 0, 0));
        return ret;
    }

    @Override
    public Marker ifge() {
        Marker ret = new Marker(this.instructions, 1);
        this.add(-1, new Instruction(156, 0, 0));
        return ret;
    }

    @Override
    public Marker ifgt() {
        Marker ret = new Marker(this.instructions, 1);
        this.add(-1, new Instruction(157, 0, 0));
        return ret;
    }

    @Override
    public Marker ifle() {
        Marker ret = new Marker(this.instructions, 1);
        this.add(-1, new Instruction(158, 0, 0));
        return ret;
    }

    @Override
    public Marker ifopcode(int opcode) {
        Marker ret = new Marker(this.instructions, 1);
        this.add(-2, new Instruction(opcode, 0, 0));
        return ret;
    }

    @Override
    public Marker ifnull() {
        Marker ret = new Marker(this.instructions, 1);
        this.add(-1, new Instruction(198, 0, 0));
        return ret;
    }

    @Override
    public Marker ifnonnull() {
        Marker ret = new Marker(this.instructions, 1);
        this.add(-1, new Instruction(199, 0, 0));
        return ret;
    }

    @Override
    public void iload(int i) {
        if (i < 4) {
            this.add(1, new Instruction(26 + i));
        } else {
            this.add(1, new Instruction(21, i));
        }
    }

    @Override
    public void istore(int i) {
        if (i < 4) {
            this.add(-1, new Instruction(59 + i));
        } else {
            this.add(-1, new Instruction(54, i));
        }
        if (i >= this.locals) {
            this.locals = i + 1;
        }
    }

    @Override
    public void invokeOtherConstructor(String clz, String ... args) {
        this.invoke(183, false, clz, "void", "<init>", args);
    }

    @Override
    public void invokeParentConstructor(String ... args) {
        if (this.byteCodeCreator.getSuperClass() == null) {
            throw new UtilException("Cannot use parent methods without defining superclass");
        }
        this.invoke(183, false, this.byteCodeCreator.getSuperClass(), "void", "<init>", args);
    }

    @Override
    public void invokeParentMethod(String typeReturn, String method, String ... args) {
        if (this.byteCodeCreator.getSuperClass() == null) {
            throw new UtilException("Cannot use parent methods without defining superclass");
        }
        this.invoke(183, false, this.byteCodeCreator.getSuperClass(), typeReturn, method, args);
    }

    @Override
    public void invokeStatic(String clz, String typeReturn, String method, String ... args) {
        this.invoke(184, true, clz, typeReturn, method, args);
    }

    private int invokeIdx(String clz, String ret, String meth, byte refType, String ... args) {
        int clzIdx = this.bcf.pool.requireClass(clz);
        short methIdx = this.bcf.pool.requireUtf8(meth);
        ArrayList<String> argTypes = new ArrayList<String>();
        for (String s : args) {
            argTypes.add(MethodCreator.map(s));
        }
        short sigIdx = this.bcf.pool.requireUtf8(MethodCreator.signature(MethodCreator.map(ret), argTypes));
        int ntIdx = this.bcf.pool.requireNT(methIdx, sigIdx);
        int idx = this.bcf.pool.requireRef(refType, clzIdx, ntIdx);
        return idx;
    }

    private void addInvoke(Instruction instruction, boolean isStatic, String ret, String ... args) {
        int pop = args.length;
        if (ret.equals("void")) {
            ++pop;
        } else if (ret.equals("double") || ret.equals("long")) {
            --pop;
        }
        for (String s : args) {
            if (!s.equals("double") && !s.equals("long")) continue;
            ++pop;
        }
        if (isStatic) {
            --pop;
        }
        this.add(-pop, instruction);
    }

    private void invoke(int opcode, boolean isStatic, String clz, String ret, String meth, String ... args) {
        int idx = this.invokeIdx(clz, ret, meth, (byte)10, args);
        this.addInvoke(new Instruction(opcode, this.hi(idx), this.lo(idx)), isStatic, ret, args);
    }

    @Override
    public void invokeVirtualMethod(String clz, String ret, String method, String ... args) {
        this.invoke(182, false, clz, ret, method, args);
    }

    @Override
    public void invokeInterface(String clz, String ret, String method, String ... args) {
        int idx = this.invokeIdx(clz, ret, method, (byte)11, args);
        int count = args.length + 1;
        for (String s : args) {
            if (!s.equals("double") && !s.equals("long")) continue;
            ++count;
        }
        this.addInvoke(new Instruction(185, this.hi(idx), this.lo(idx), count, 0), false, ret, args);
    }

    @Override
    public void ireturn() {
        this.add(-1, new Instruction(172));
    }

    public void arraylength() {
        this.add(0, new Instruction(190));
    }

    @Override
    public void isInstanceOf(String ofClz) {
        int idx = this.bcf.pool.requireClass(JavaInfo.mapPrimitive(ofClz));
        this.add(0, new Instruction(193, this.hi(idx), this.lo(idx)));
    }

    @Override
    public Marker jump() {
        Marker ret = new Marker(this.instructions, 1);
        this.add(0, new Instruction(167, 0, 0));
        return ret;
    }

    @Override
    public void ldcClass(String clz) {
        int idx = this.bcf.pool.requireClass(JavaInfo.mapPrimitive(clz));
        if (idx < 256) {
            this.add(1, new Instruction(18, idx));
        } else {
            this.add(1, new Instruction(19, this.hi(idx), this.lo(idx)));
        }
    }

    @Override
    public void ldcString(String string) {
        int idx = this.bcf.pool.requireString(string);
        if (idx < 256) {
            this.add(1, new Instruction(18, idx));
        } else {
            this.add(1, new Instruction(19, this.hi(idx), this.lo(idx)));
        }
    }

    @Override
    public void lload(int i) {
        if (i < 4) {
            this.add(2, new Instruction(30 + i));
        } else {
            this.add(2, new Instruction(22, i));
        }
    }

    @Override
    public void lreturn() {
        this.add(-2, new Instruction(173));
    }

    @Override
    public void lstore(int i) {
        if (i < 4) {
            this.add(-2, new Instruction(63 + i));
        } else {
            this.add(-2, new Instruction(55, i));
        }
        if (i >= this.locals) {
            this.locals = i + 1;
        }
    }

    @Override
    public Marker marker() {
        return new Marker(this.instructions, 1);
    }

    @Override
    public Expr markHere(Remarker r) {
        return new RemarkerExpr(this, r);
    }

    @Override
    public void newObject(String clz) {
        int idx = this.bcf.pool.requireClass(clz);
        this.add(1, new Instruction(187, idx >> 8, idx & 0xFF));
    }

    @Override
    public void pop(String type) {
        if (type.equals("void")) {
            return;
        }
        if (type.equals("double") || type.equals("long")) {
            this.add(-2, new Instruction(88));
        } else {
            this.add(-1, new Instruction(87));
        }
    }

    @Override
    public void putField(String clz, String type, String var) {
        int clzIdx = this.bcf.pool.requireClass(clz);
        short fieldIdx = this.bcf.pool.requireUtf8(var);
        short sigIdx = this.bcf.pool.requireUtf8(MethodCreator.map(type));
        int ntIdx = this.bcf.pool.requireNT(fieldIdx, sigIdx);
        int idx = this.bcf.pool.requireRef(9, clzIdx, ntIdx);
        int pop = -2;
        if (type.equals("double") || type.equals("long")) {
            pop = -3;
        }
        this.add(pop, new Instruction(181, idx >> 8, idx & 0xFF));
    }

    @Override
    public void putStatic(String clz, String type, String var) {
        int clzIdx = this.bcf.pool.requireClass(clz);
        short fieldIdx = this.bcf.pool.requireUtf8(var);
        short sigIdx = this.bcf.pool.requireUtf8(MethodCreator.map(type));
        int ntIdx = this.bcf.pool.requireNT(fieldIdx, sigIdx);
        int idx = this.bcf.pool.requireRef(9, clzIdx, ntIdx);
        int pop = -1;
        if (type.equals("double") || type.equals("long")) {
            pop = -2;
        }
        this.add(pop, new Instruction(179, idx >> 8, idx & 0xFF));
    }

    @Override
    public void vreturn() {
        this.add(0, new Instruction(177));
    }

    @Override
    public Annotation addRTVAnnotation(String attrClass) {
        Annotation ret = new Annotation(this.bcf, attrClass);
        this.annotations.add(AnnotationType.RuntimeVisibleAnnotations, ret);
        return ret;
    }

    @Override
    public Annotation addRTVPAnnotation(String attrClass, int param) {
        Annotation ret = new Annotation(this.bcf, attrClass, param);
        this.annotations.add(AnnotationType.RuntimeVisibleParameterAnnotations, ret);
        return ret;
    }

    public void addException(String exType, Marker from, Marker to, Marker handler) {
        this.exceptionHandlers.add(new ExceptionHandler(this.bcf.pool.requireClass(exType), from, to, handler));
    }

    @Override
    public int nextLocal() {
        return this.locals++;
    }

    @Override
    public ByteCodeCreator getBCC() {
        return this.byteCodeCreator;
    }

    @Override
    public String getClassName() {
        return this.byteCodeCreator.getCreatedName();
    }

    @Override
    public int stackDepth() {
        return this.opdepth;
    }

    @Override
    public void resetStack(int to) {
        this.opdepth = to;
    }

    @Override
    public String toString() {
        return "Method[" + this.returnType + " " + this.getClassName() + "::" + this.name + "]";
    }
}

