/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.util.List;
import org.zinutils.bytecode.Instruction;

public class Marker {
    private final List<Instruction> instructions;
    private final int offset;
    private final int pointer;

    public Marker(List<Instruction> instructions, int offset) {
        this.instructions = instructions;
        this.pointer = instructions.size();
        this.offset = offset;
    }

    public void setHere() {
        int count = 0;
        int k = 0;
        for (Instruction i : this.instructions) {
            if (k++ < this.pointer) continue;
            count += i.length();
        }
        Instruction jump = this.instructions.get(this.pointer);
        jump.setLocation(this.offset, count);
    }

    public int getLocation() {
        int count = 0;
        for (int k = 0; k < this.instructions.size() && k < this.pointer; ++k) {
            count += this.instructions.get(k).length();
        }
        return count;
    }

    public String toString() {
        return "Marker[" + this.offset + ":" + this.pointer + "]";
    }
}

