/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.utils.Justification;

public class MakeNewExpr
extends Expr {
    private final String ofClz;
    private final IExpr[] args;
    private final boolean dupNew;

    public MakeNewExpr(MethodDefiner meth, String ofClz, boolean dupNew, IExpr ... args) {
        super(meth);
        this.ofClz = ofClz;
        this.dupNew = dupNew;
        this.args = args;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        meth.newObject(this.ofClz);
        if (this.dupNew) {
            meth.dup();
        }
        String[] argTypes = new String[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            Expr e = (Expr)this.args[i];
            argTypes[i] = e.getType();
            e.spitOutByteCode(meth);
        }
        meth.invokeOtherConstructor(this.ofClz, argTypes);
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        if (!suppressFirst) {
            sb.append(Justification.LEFT.format("", ind));
            lnt.advance(1);
        }
        if (!this.dupNew) {
            sb.append("(void)");
        }
        sb.append("new ");
        sb.append(this.ofClz);
        sb.append("(");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            ((Expr)this.args[i]).asSource(sb, lnt, ind + 2, true);
        }
        sb.append(")");
        if (!suppressFirst) {
            sb.append("\n");
        }
    }

    @Override
    public String getType() {
        return this.ofClz;
    }
}

