/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class LineNumberTable {
    private final Map<Integer, Integer> lineMapping = new TreeMap<Integer, Integer>();
    private int lineNo;

    public LineNumberTable(int lineNo) {
        this.lineNo = lineNo;
    }

    public int current() {
        return this.lineNo;
    }

    public void advance(int n) {
        this.lineNo += n;
    }

    public void add(int frompc) {
        this.lineMapping.put(frompc, this.lineNo);
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(2 + 4 * this.lineMapping.size());
        dos.writeShort(this.lineMapping.size());
        for (Map.Entry<Integer, Integer> e : this.lineMapping.entrySet()) {
            int pc = e.getKey();
            dos.write((byte)(pc >> 8 & 0xFF));
            dos.write((byte)pc & 0xFF);
            int line = e.getValue();
            dos.write((byte)(line >> 8 & 0xFF));
            dos.write((byte)line & 0xFF);
        }
    }
}

