/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.JavaInfo;
import org.zinutils.exceptions.UtilException;

public class JavaType
extends JavaInfo {
    public static final JavaType boolean_ = new JavaType("boolean");
    public static final JavaType byte_ = new JavaType("byte");
    public static final JavaType date = new JavaType("java.util.Date");
    public static final JavaType double_ = new JavaType("double");
    public static final JavaType int_ = new JavaType("int");
    public static final JavaType long_ = new JavaType("long");
    public static final JavaType object_ = new JavaType("java.lang.Object");
    public static final JavaType string = new JavaType("java.lang.String");
    public static final JavaType void_ = new JavaType("void");
    public static final JavaType serializable = new JavaType("java.io.Serializable");
    private final String actual;
    private final JavaType[] generics;
    private boolean extended;

    public JavaType(String actual) {
        this.actual = actual;
        this.generics = new JavaType[0];
    }

    public JavaType(String actual, String ... generics) {
        this.actual = actual;
        this.generics = new JavaType[generics.length];
        int pos = 0;
        for (String s : generics) {
            if (s == null) {
                throw new UtilException("Null generic passed to " + actual);
            }
            this.generics[pos++] = new JavaType(s);
        }
    }

    public JavaType(String actual, JavaType ... generics) {
        this.actual = actual;
        this.generics = generics;
        for (JavaType gen : generics) {
            if (gen != null) continue;
            throw new UtilException("Null generic passed to " + actual);
        }
    }

    public String asSignature() {
        return JavaType.map(this.actual);
    }

    public String asGeneric() {
        if (this.generics == null || this.generics.length == 0) {
            return this.asSignature();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(JavaInfo.map(this.actual));
        sb.insert(sb.length() - 1, "<");
        for (JavaType jt : this.generics) {
            if (jt.extended) {
                sb.insert(sb.length() - 1, "+");
            }
            sb.insert(sb.length() - 1, jt.asGeneric());
        }
        sb.insert(sb.length() - 1, ">");
        return sb.toString();
    }

    public String getActual() {
        return this.actual;
    }

    public boolean isGeneric() {
        return this.generics != null && this.generics.length > 0;
    }

    public boolean equals(Object other) {
        return super.equals(other) || other instanceof JavaType && this.actual.equals(((JavaType)other).actual);
    }

    public JavaType orExtended() {
        this.extended = true;
        return this;
    }

    public boolean isPrimitive() {
        return boolean_.getActual().equals(this.actual) || byte_.getActual().equals(this.actual) || double_.getActual().equals(this.actual) || int_.getActual().equals(this.actual) || long_.getActual().equals(this.actual);
    }

    public String toString() {
        return this.actual + (String)(this.generics != null && this.generics.length > 0 ? ":" + this.generics.length : "");
    }
}

