/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;
import org.zinutils.utils.ZUJarEntry;
import org.zinutils.utils.ZUJarFile;

public class JavaRuntimeReplica {
    private final List<JRRChecker> roots = new ArrayList<JRRChecker>();
    private final Map<String, ByteCodeFile> cache = new HashMap<String, ByteCodeFile>();

    public void add(File path) {
        for (JRRChecker c : this.roots) {
            if (!c.forPath(path)) continue;
            return;
        }
        if (path.getName().endsWith(".jar") || path.getName().endsWith(".zip")) {
            this.roots.add(new JRRJarChecker(path));
        } else {
            this.roots.add(new JRRFSChecker(path));
        }
    }

    public ByteCodeFile getClass(String clz) {
        if (this.cache.containsKey(clz)) {
            return this.cache.get(clz);
        }
        File clzpath = FileUtils.convertDottedToPathWithExtension(clz, ".class");
        for (JRRChecker checker : this.roots) {
            ByteCodeFile ret = checker.read(clz, clzpath);
            if (ret == null) continue;
            this.cache.put(clz, ret);
            return ret;
        }
        throw new UtilException("JRR cannot find any version of " + clz);
    }

    public void close() {
        for (JRRChecker checker : this.roots) {
            checker.close();
        }
    }

    public abstract class JRRChecker {
        public abstract ByteCodeFile read(String var1, File var2);

        public abstract void close();

        public abstract boolean forPath(File var1);
    }

    public class JRRJarChecker
    extends JRRChecker {
        private final ZUJarFile jar;

        public JRRJarChecker(File path) {
            this.jar = new ZUJarFile(path);
        }

        @Override
        public ByteCodeFile read(String clz, File clzpath) {
            ZUJarEntry e = this.jar.get(FileUtils.posixPath(clzpath));
            if (e != null) {
                return new ByteCodeFile(e.asStream());
            }
            return null;
        }

        @Override
        public boolean forPath(File path) {
            return this.jar.getFile().equals(path);
        }

        @Override
        public void close() {
            this.jar.close();
        }
    }

    public class JRRFSChecker
    extends JRRChecker {
        private final File root;

        public JRRFSChecker(File root) {
            this.root = root;
        }

        @Override
        public ByteCodeFile read(String clz, File clzpath) {
            File from = FileUtils.combine(this.root, clzpath);
            if (from.canRead()) {
                return new ByteCodeFile(from, clz);
            }
            return null;
        }

        @Override
        public boolean forPath(File path) {
            return this.root.equals(path);
        }

        @Override
        public void close() {
        }
    }
}

