/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;

public class JavaInfo {
    public static String mapPrimitive(String type) {
        return JavaInfo.mapInternal(type, false);
    }

    public static String map(String type) {
        return JavaInfo.mapInternal(type, true);
    }

    private static String mapInternal(String type, boolean mapLongTypes) {
        if (type.startsWith("@")) {
            return type.substring(1);
        }
        if (type.equals("?")) {
            return "*";
        }
        int dims = 0;
        while (type.charAt(dims) == '[') {
            ++dims;
        }
        return type.substring(0, dims) + JavaInfo.mapScalar(type.substring(dims), mapLongTypes);
    }

    public static String unmap(String mapped) {
        return JavaInfo.unmap(mapped, true);
    }

    public static String unmap(String mapped, boolean dot) {
        if (mapped.startsWith("@")) {
            return JavaInfo.unmap(mapped.substring(1));
        }
        if (mapped.equals("*")) {
            return "?";
        }
        if (mapped.startsWith("(")) {
            throw new UtilException("Use unmapSignature for signatures");
        }
        int dims = 0;
        while (mapped.charAt(dims) == '[') {
            ++dims;
        }
        return mapped.substring(0, dims) + JavaInfo.unmapScalar(mapped.substring(dims), dot);
    }

    public static String mapSignature(List<String> rewrite) {
        StringBuilder ret = new StringBuilder();
        ret.append("(");
        for (int i = 1; i < rewrite.size(); ++i) {
            ret.append(JavaInfo.map(rewrite.get(i)));
        }
        ret.append(")");
        ret.append(JavaInfo.map(rewrite.get(0)));
        return ret.toString();
    }

    public static List<String> unmapSignature(String mapped, boolean unmapContained) {
        if (!mapped.startsWith("(")) {
            throw new UtilException("Not a signature");
        }
        int crbidx = mapped.indexOf(41);
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(JavaInfo.unmap(mapped.substring(crbidx + 1), unmapContained));
        int from = 1;
        while (from < crbidx) {
            int end = from;
            while (mapped.charAt(end) == '[') {
                ++end;
            }
            if (mapped.charAt(end) == 'L') {
                end = mapped.indexOf(59, end);
            }
            ret.add(JavaInfo.unmap(mapped.substring(from, ++end), unmapContained));
            from = end;
        }
        return ret;
    }

    public static List<String> simplify(String sig) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(JavaInfo.unmap(sig, false));
        return ret;
    }

    private static String mapScalar(String type, boolean mapLongTypes) {
        if (type.equals("void")) {
            return "V";
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("boolean")) {
            return "Z";
        }
        if (mapLongTypes) {
            return "L" + FileUtils.convertDottedToSlashPath(type) + ";";
        }
        return type;
    }

    private static String unmapScalar(String mapped, boolean cnvDotted) {
        if (mapped.equals("V")) {
            return "void";
        }
        if (mapped.equals("I")) {
            return "int";
        }
        if (mapped.equals("B")) {
            return "byte";
        }
        if (mapped.equals("C")) {
            return "char";
        }
        if (mapped.equals("D")) {
            return "double";
        }
        if (mapped.equals("F")) {
            return "float";
        }
        if (mapped.equals("J")) {
            return "long";
        }
        if (mapped.equals("S")) {
            return "short";
        }
        if (mapped.equals("Z")) {
            return "boolean";
        }
        String ret = mapped.substring(1, mapped.length() - 1);
        if (cnvDotted) {
            return FileUtils.convertToDottedName(new File(ret));
        }
        return ret;
    }

    public static enum Access {
        PRIVATE,
        PUBLIC,
        PROTECTED,
        DEFAULT,
        PROTECTEDTRANSIENT,
        PRIVATESTATIC,
        PUBLICSTATIC,
        DEFAULTSTATIC,
        PUBLICTRANSIENT,
        PUBLICABSTRACT,
        PUBLICABSTRACTSTATIC,
        PUBLICSTATICINTERFACE,
        ACCESS,
        STATICACCESS,
        ENUM,
        PRIVATEACCESS;


        public short asShort() {
            switch (this) {
                case PRIVATE: {
                    return 2;
                }
                case PRIVATESTATIC: {
                    return 10;
                }
                case PROTECTED: {
                    return 4;
                }
                case PROTECTEDTRANSIENT: {
                    return 132;
                }
                case DEFAULT: {
                    return 0;
                }
                case DEFAULTSTATIC: {
                    return 8;
                }
                case PUBLIC: {
                    return 1;
                }
                case PUBLICSTATIC: {
                    return 9;
                }
                case PUBLICTRANSIENT: {
                    return 129;
                }
                case PUBLICABSTRACT: {
                    return 1025;
                }
                case PUBLICABSTRACTSTATIC: {
                    return 1033;
                }
                case PUBLICSTATICINTERFACE: {
                    return 1545;
                }
                case ACCESS: {
                    return 4096;
                }
                case PRIVATEACCESS: {
                    return 4098;
                }
                case STATICACCESS: {
                    return 4104;
                }
                case ENUM: {
                    return 16409;
                }
            }
            throw new UtilException("Invalid access");
        }

        public boolean isStatic() {
            return this == PRIVATESTATIC || this == DEFAULTSTATIC || this == PUBLICSTATIC;
        }
    }
}

