/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.StringUtil;

public class Instruction {
    private final int[] bytes;

    public Instruction(int ... bytes) {
        this.bytes = bytes;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 0 && bytes[i] <= 255) continue;
            throw new UtilException("byte out of range: " + bytes[i]);
        }
    }

    public int length() {
        return this.bytes.length;
    }

    public int usesVar() {
        int opcode = this.bytes[0];
        if (opcode >= 42 && opcode <= 45) {
            return opcode - 42;
        }
        if (opcode == 25) {
            return this.bytes[1];
        }
        if (opcode >= 75 && opcode <= 78) {
            return opcode - 75;
        }
        if (opcode == 58) {
            return this.bytes[1];
        }
        if (opcode >= 38 && opcode <= 41) {
            return opcode - 38 + 1;
        }
        if (opcode == 24) {
            return this.bytes[1] + 1;
        }
        if (opcode >= 71 && opcode <= 74) {
            return opcode - 71 + 1;
        }
        if (opcode == 57) {
            return this.bytes[1] + 1;
        }
        if (opcode >= 26 && opcode <= 29) {
            return opcode - 26;
        }
        if (opcode == 21) {
            return this.bytes[1];
        }
        if (opcode >= 59 && opcode <= 62) {
            return opcode - 59;
        }
        if (opcode == 54) {
            return this.bytes[1];
        }
        if (opcode >= 30 && opcode <= 33) {
            return opcode - 30 + 1;
        }
        if (opcode == 22) {
            return this.bytes[1] + 1;
        }
        if (opcode >= 63 && opcode <= 66) {
            return opcode - 63 + 1;
        }
        if (opcode == 55) {
            return this.bytes[1] + 1;
        }
        return -1;
    }

    public void write(DataOutputStream dos) throws IOException {
        for (int b : this.bytes) {
            dos.writeByte(b);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.bytes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(StringUtil.hex(this.bytes[i] & 0xFF, 2));
        }
        sb.append("}");
        return sb.toString();
    }

    public void setLocation(int offset, int count) {
        this.bytes[offset] = count >> 8 & 0xFF;
        this.bytes[offset + 1] = count & 0xFF;
    }
}

