/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.JavaInfo;

public class InnerClass
implements Comparable<InnerClass> {
    private final JavaInfo.Access access;
    private final int inner;
    private final int enclosing;
    private final int innerName;

    public InnerClass(ByteCodeFile bcf, JavaInfo.Access access, String projClz, String enclosingClass, String innerName) {
        this.access = access;
        this.inner = bcf.pool.requireClass(projClz);
        this.enclosing = enclosingClass == null ? 0 : bcf.pool.requireClass(enclosingClass);
        this.innerName = innerName == null ? 0 : (int)bcf.pool.requireUtf8(innerName);
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeShort(this.inner);
        dos.writeShort(this.enclosing);
        dos.writeShort(this.innerName);
        dos.writeShort(this.access.asShort());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InnerClass)) {
            return false;
        }
        InnerClass other = (InnerClass)obj;
        return this.inner == other.inner && this.enclosing == other.enclosing;
    }

    public int hashCode() {
        return this.inner * this.enclosing;
    }

    @Override
    public int compareTo(InnerClass o) {
        if (this.enclosing < o.enclosing) {
            return -1;
        }
        if (this.enclosing > o.enclosing) {
            return 1;
        }
        if (this.inner < o.inner) {
            return -1;
        }
        if (this.inner > o.inner) {
            return 1;
        }
        return 0;
    }
}

