/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.BlockExpr;
import org.zinutils.bytecode.EqualsExpr;
import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.Marker;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.ReturnX;
import org.zinutils.bytecode.StackMapFrame;
import org.zinutils.bytecode.ThrowExpr;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.Justification;

public class IfExpr
extends Expr {
    private final IExpr test;
    private final int opcode;
    private final IExpr lhs;
    private final IExpr rhs;
    private final IExpr then;
    private final IExpr orelse;
    private final IfCond cond;

    public IfExpr(MethodDefiner meth, IExpr left, IExpr right, IExpr then, IExpr orelse) {
        this(meth, (IExpr)new EqualsExpr(meth, left, right), then, orelse, IfCond.TRUE);
    }

    public IfExpr(MethodDefiner meth, IExpr test, boolean sign, IExpr then, IExpr orelse) {
        this(meth, test, then, orelse, sign ? IfCond.TRUE : IfCond.FALSE);
    }

    public IfExpr(MethodDefiner meth, IExpr test, IExpr then, IExpr orelse, IfCond cond) {
        super(meth);
        this.test = test;
        this.opcode = -1;
        this.lhs = null;
        this.rhs = null;
        this.then = then;
        this.orelse = orelse;
        this.cond = cond;
    }

    public IfExpr(MethodCreator meth, int i, IExpr lhs, IExpr rhs, IExpr then, IExpr orelse) {
        super(meth);
        this.test = null;
        this.opcode = i;
        this.lhs = lhs;
        this.rhs = rhs;
        this.then = then;
        this.orelse = orelse;
        this.cond = null;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        Marker m1;
        if (this.opcode != -1) {
            this.lhs.spitOutByteCode(meth);
            this.rhs.spitOutByteCode(meth);
            m1 = meth.ifopcode(this.opcode);
        } else {
            this.test.spitOutByteCode(meth);
            switch (this.cond) {
                case TRUE: {
                    m1 = meth.ifeq();
                    break;
                }
                case FALSE: {
                    m1 = meth.ifne();
                    break;
                }
                case NULL: {
                    m1 = meth.ifnonnull();
                    break;
                }
                case NOTNULL: {
                    m1 = meth.ifnull();
                    break;
                }
                default: {
                    throw new UtilException("There is no case " + this.cond);
                }
            }
        }
        int depth = meth.stackDepth();
        if (this.then != null) {
            this.then.spitOutByteCode(meth);
        }
        if (this.orelse != null) {
            meth.resetStack(depth);
            Marker m2 = null;
            if (!IfExpr.isTransfer(this.then)) {
                m2 = meth.jump();
            }
            m1.setHere();
            this.orelse.spitOutByteCode(meth);
            if (m2 != null) {
                m2.setHere();
            }
        } else {
            m1.setHere();
            meth.addStackMapFrame(StackMapFrame.SAME_FRAME, meth.marker(), new String[0]);
        }
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        sb.append(Justification.LEFT.format("", ind));
        sb.append("if (");
        if (this.cond == IfCond.FALSE) {
            sb.append("!");
        }
        if (this.test != null) {
            this.test.asSource(sb, lnt, ind, true);
        } else {
            this.lhs.asSource(sb, lnt, ind, true);
            if (this.opcode == 162) {
                sb.append("<");
            } else if (this.opcode == 159 || this.opcode == 165) {
                sb.append("!=");
            } else if (this.opcode == 160 || this.opcode == 166) {
                sb.append("==");
            } else {
                sb.append(" <" + this.opcode + "> ");
            }
            this.rhs.asSource(sb, lnt, ind, true);
        }
        if (this.cond == IfCond.NOTNULL) {
            sb.append(" != null");
        }
        if (this.cond == IfCond.NULL) {
            sb.append(" == null");
        }
        sb.append(") {\n");
        lnt.advance(1);
        if (this.then != null) {
            this.then.asSource(sb, lnt, ind + 2, false);
        }
        if (this.orelse != null) {
            sb.append(Justification.LEFT.format("", ind));
            sb.append("} else {\n");
            lnt.advance(1);
            this.orelse.asSource(sb, lnt, ind + 2, false);
        }
        sb.append(Justification.LEFT.format("", ind));
        sb.append("}\n");
        lnt.advance(1);
    }

    @Override
    public String getType() {
        throw new UtilException("This is void, which might, in some cases, be valid, but I haven't seen one yet");
    }

    public static boolean isTransfer(IExpr expr) {
        if (expr instanceof ReturnX || expr instanceof ThrowExpr) {
            return true;
        }
        if (expr instanceof IfExpr) {
            return true;
        }
        if (expr instanceof BlockExpr) {
            return ((BlockExpr)expr).endsWithTransfer();
        }
        return false;
    }

    public static enum IfCond {
        TRUE,
        FALSE,
        NULL,
        NOTNULL;

    }
}

