/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.bytecode.FieldInfo;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.Var;
import org.zinutils.exceptions.UtilException;

public class GenericAnnotator {
    private String returnType;
    private StringBuilder sb = new StringBuilder();
    private int argPointer;
    private boolean hasGenerics;
    private final ByteCodeSink bcc;
    private final String name;
    private List<PendingVar> vars = new ArrayList<PendingVar>();
    private final boolean isStatic;
    private List<GenAnnotation> anns = new ArrayList<GenAnnotation>();

    private GenericAnnotator(ByteCodeSink projectionClass, boolean isStatic, String name) {
        this.bcc = projectionClass;
        this.isStatic = isStatic;
        this.name = name;
    }

    private GenericAnnotator(ByteCodeSink projectionClass) {
        this.bcc = projectionClass;
        this.isStatic = false;
        this.name = null;
    }

    public static GenericAnnotator newMethod(ByteCodeSink projectionClass, boolean isStatic, String name) {
        GenericAnnotator ret = new GenericAnnotator(projectionClass, isStatic, name);
        ret.sb.append("()");
        ret.argPointer = 1;
        return ret;
    }

    public static GenericAnnotator newConstructor(ByteCodeSink bcc, boolean isStatic) {
        GenericAnnotator ret = isStatic ? GenericAnnotator.newMethod(bcc, true, "<clinit>") : GenericAnnotator.newMethod(bcc, false, "<init>");
        ret.returns(new JavaType("void"));
        return ret;
    }

    public static GenericAnnotator forClass(ByteCodeSink projectionClass) {
        return new GenericAnnotator(projectionClass);
    }

    public void parentClass(String cls) {
        this.parentClass(new JavaType(cls));
    }

    public void parentClass(JavaType jt) {
        this.sb.append(jt.asGeneric());
        this.hasGenerics |= jt.isGeneric();
    }

    public void returns(String str) {
        this.returns(new JavaType(str));
    }

    public void returns(JavaType jt) {
        if (this.returnType != null) {
            throw new UtilException("You cannot specify more than one return type");
        }
        this.returnType = jt.getActual();
        if (this.sb == null) {
            throw new UtilException("You cannot continue to use annotator after completion");
        }
        this.sb.append(jt.asGeneric());
        this.hasGenerics |= jt.isGeneric();
    }

    public PendingVar argument(String cs, String name) {
        return this.argument(new JavaType(cs), name);
    }

    public PendingVar argument(JavaType jt, String name) {
        if (this.sb == null) {
            throw new UtilException("You cannot continue to use annotator after completion");
        }
        this.hasGenerics |= jt.isGeneric();
        this.sb.insert(this.argPointer, jt.asGeneric());
        this.argPointer += jt.asGeneric().length();
        PendingVar ret = new PendingVar(jt, name, this.vars.size());
        this.vars.add(ret);
        return ret;
    }

    public MethodDefiner done() {
        if (this.sb == null) {
            throw new UtilException("You have already completed this method");
        }
        if (this.name == null) {
            if (this.hasGenerics) {
                this.bcc.signatureAttribute("Signature", this.sb.toString());
            }
            return null;
        }
        if (this.returnType == null) {
            throw new UtilException("You have not specified the return type");
        }
        MethodDefiner ret = this.bcc.createMethod(this.isStatic, this.returnType, this.name);
        if (this.hasGenerics) {
            ret.addAttribute("Signature", this.sb.toString());
        }
        this.sb = null;
        for (GenAnnotation ann : this.anns) {
            ann.applyTo(ret);
        }
        for (PendingVar p : this.vars) {
            p.apply(ret);
        }
        return ret;
    }

    public static void annotateField(FieldInfo fi, JavaType jt) {
        if (jt.isGeneric()) {
            fi.attribute("Signature", jt.asGeneric());
        }
    }

    public static void createField(ByteCodeSink projectionClass, boolean isStatic, JavaInfo.Access access, JavaType javaType, String name) {
        projectionClass.defineField(isStatic, access, javaType, name);
    }

    public GenAnnotation addRTVAnnotation(String annotation) {
        GenAnnotation ret = new GenAnnotation(annotation);
        this.anns.add(ret);
        return ret;
    }

    public static class PendingVar {
        private final JavaType type;
        private final String name;
        private Var var;
        private List<ArgAnnotation> anns = new ArrayList<ArgAnnotation>();
        private final int pos;

        public PendingVar(JavaType type, String name, int pos) {
            this.type = type;
            this.name = name;
            this.pos = pos;
        }

        public PendingVar apply(MethodDefiner meth) {
            this.var = meth.argument(this.type.getActual(), this.name);
            for (ArgAnnotation aa : this.anns) {
                aa.applyTo(meth, this.pos);
            }
            return this;
        }

        public Var getVar() {
            if (this.var == null) {
                throw new UtilException("Must apply before get()");
            }
            return this.var;
        }

        public ArgAnnotation addRTVPAnnotation(String pathparam) {
            ArgAnnotation ret = new ArgAnnotation(pathparam);
            this.anns.add(ret);
            return ret;
        }
    }

    public static class GenAnnotation {
        protected final String attrClass;
        protected final List<AnnArg> args = new ArrayList<AnnArg>();

        public GenAnnotation(String attrClass) {
            this.attrClass = attrClass;
        }

        public void addParam(String string, String value) {
            this.args.add(new AnnArg(string, value));
        }

        public void addParam(String string, String ... strings) {
            this.args.add(new AnnArg(string, strings));
        }

        public void applyTo(MethodDefiner meth) {
            this.handleArgs(meth.addRTVAnnotation(this.attrClass));
        }

        protected void handleArgs(Annotation methAnn) {
            for (AnnArg aa : this.args) {
                if (aa.string != null) {
                    methAnn.addParam(aa.name, aa.string);
                    continue;
                }
                methAnn.addParam(aa.name, aa.args);
            }
        }
    }

    public static class ArgAnnotation
    extends GenAnnotation {
        public ArgAnnotation(String pathparam) {
            super(pathparam);
        }

        public void applyTo(MethodDefiner meth, int pos) {
            this.handleArgs(meth.addRTVPAnnotation(this.attrClass, pos));
        }
    }

    public static class AnnArg {
        private final String name;
        private final String string;
        private final String[] args;

        public AnnArg(String name, String value) {
            this.name = name;
            this.string = value;
            this.args = null;
        }

        public AnnArg(String name, String[] args) {
            this.name = name;
            this.string = null;
            this.args = args;
        }
    }
}

