/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.AnnotationHolder;
import org.zinutils.bytecode.AnnotationType;
import org.zinutils.bytecode.AttributeInfo;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.IFieldInfo;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.collections.ListMap;

public class FieldInfo
extends JavaInfo
implements AnnotationHolder,
IFieldInfo {
    private final ByteCodeFile bcf;
    private int access_flags;
    private short name_idx;
    private short descriptor_idx;
    final List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
    private final ListMap<AnnotationType, Annotation> annotations = new ListMap(AnnotationType.sortOrder);

    public FieldInfo(ByteCodeFile bcf, boolean isFinal, JavaInfo.Access access, String type, String var) {
        this.bcf = bcf;
        int flags = access.asShort();
        if (isFinal) {
            flags |= 0x10;
        }
        this.access_flags = flags;
        this.name_idx = bcf.pool.requireUtf8(var);
        this.descriptor_idx = bcf.pool.requireUtf8(FieldInfo.map(type));
    }

    public FieldInfo(ByteCodeFile bcf, int access, int name, int descriptor) {
        this.bcf = bcf;
        this.access_flags = access;
        this.name_idx = (short)name;
        this.descriptor_idx = (short)descriptor;
    }

    @Override
    public IExpr asExpr(NewMethodDefiner meth) {
        return meth.getField(this.getName());
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeShort(this.access_flags);
        dos.writeShort(this.name_idx);
        dos.writeShort(this.descriptor_idx);
        this.bcf.writeAttributes(dos, this.attributes);
    }

    public void complete() throws IOException {
        for (AnnotationType at : this.annotations) {
            at.addTo(this.bcf, this.attributes, this.annotations.get(at), -1);
        }
    }

    public Annotation addRTVAnnotation(String attrClass) {
        return this.addAnnotation(AnnotationType.RuntimeVisibleAnnotations, new Annotation(this.bcf, attrClass));
    }

    public void attribute(String named, String text) {
        short ptr = this.bcf.pool.requireUtf8(text);
        byte[] data = new byte[]{(byte)(ptr >> 8), (byte)(ptr & 0xFF)};
        this.attributes.add(this.bcf.newAttribute(named, data));
    }

    @Override
    public Annotation addAnnotation(AnnotationType type, Annotation ann) {
        this.annotations.add(type, ann);
        return ann;
    }

    @Override
    public void constValue(String fullName) {
        int ptr = this.bcf.pool.requireString(fullName);
        byte[] data = new byte[]{(byte)(ptr >> 8), (byte)(ptr & 0xFF)};
        this.attributes.add(this.bcf.newAttribute("ConstantValue", data));
    }

    @Override
    public void constValue(int value) {
        short ptr = this.bcf.pool.requireInteger(value);
        byte[] data = new byte[]{(byte)(ptr >> 8), (byte)(ptr & 0xFF)};
        this.attributes.add(this.bcf.newAttribute("ConstantValue", data));
    }

    public Annotation getClassAnnotation(String ann) {
        for (AnnotationType i : this.annotations) {
            for (Annotation j : this.annotations.get(i)) {
                if (!j.name.equals(ann)) continue;
                return j;
            }
        }
        return null;
    }

    public int getDescriptorIdx() {
        return this.descriptor_idx;
    }

    public String getSignature() {
        return ((CPInfo.Utf8Info)this.bcf.pool.get(this.descriptor_idx)).asString();
    }

    public void setSignature(String rw) {
        this.bcf.pool.setPoolEntry(this.descriptor_idx, new CPInfo.Utf8Info(rw));
    }

    public int getAccess() {
        return this.access_flags;
    }

    public String getName() {
        return this.bcf.pool.get(this.name_idx).asClean();
    }

    public String toString() {
        if (this.name_idx != -1) {
            return "Field[" + this.bcf.pool.get(this.name_idx) + "]";
        }
        return "Field[?]";
    }
}

