/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.exceptions.UtilException;

public class FieldExpr
extends Expr {
    private final IExpr from;
    private final String clzName;
    private final JavaType type;
    private final String fieldName;

    public FieldExpr(NewMethodDefiner meth, IExpr from, String clzName, String type, String named) {
        this(meth, from, clzName, new JavaType(type), named);
    }

    public FieldExpr(NewMethodDefiner meth, IExpr from, String clzName, JavaType type, String named) {
        super(meth);
        if (type == null) {
            throw new UtilException("Type cannot be null");
        }
        this.from = from;
        this.clzName = clzName;
        this.type = type;
        this.fieldName = named;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        if (this.from == null) {
            meth.getStatic(this.clzName, this.type.getActual(), this.fieldName);
        } else {
            this.from.spitOutByteCode(meth);
            meth.getField(this.clzName, this.type.getActual(), this.fieldName);
        }
    }

    public void prepare(MethodDefiner meth) {
        if (this.from != null) {
            this.from.spitOutByteCode(meth);
        }
    }

    public void put(MethodDefiner meth) {
        if (this.from == null) {
            meth.putStatic(this.clzName, this.type.getActual(), this.fieldName);
        } else {
            meth.putField(this.clzName, this.type.getActual(), this.fieldName);
        }
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    @Override
    public String getType() {
        return this.type.getActual();
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        if (this.from != null) {
            this.from.asSource(sb, lnt, ind, false);
        } else if (this.clzName != null) {
            sb.append(this.clzName);
        }
        sb.append(".");
        sb.append(this.fieldName);
    }

    public String toString() {
        return "Field[" + this.clzName + ":" + this.fieldName + " " + this.type + "]";
    }
}

