/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;

public class EqualsExpr
extends Expr {
    private final IExpr left;
    private final IExpr right;

    public EqualsExpr(MethodDefiner meth, IExpr left, IExpr right) {
        super(meth);
        this.left = left;
        this.right = right;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        this.left.spitOutByteCode(meth);
        this.right.spitOutByteCode(meth);
        meth.invokeVirtualMethod(this.left.getType(), "boolean", "equals", "java.lang.Object");
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        sb.append("equals(");
        if (this.left != null) {
            this.left.asSource(sb, lnt, ind, true);
        }
        sb.append(",");
        if (this.right != null) {
            this.right.asSource(sb, lnt, ind, true);
        }
        sb.append(")");
    }

    @Override
    public String getType() {
        return "boolean";
    }
}

