/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.NewMethodDefiner;

public class EnclosingMethod
implements Comparable<EnclosingMethod> {
    private final int clazz;
    private final int meth;

    public EnclosingMethod(ByteCodeFile bcf, String clazz, NewMethodDefiner method) {
        this.clazz = bcf.pool.requireClass(clazz);
        MethodCreator mc = (MethodCreator)method;
        this.meth = bcf.pool.requireNT(bcf.pool.requireUtf8(mc.getName()), bcf.pool.requireUtf8(mc.signature()));
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeShort(this.clazz);
        dos.writeShort(this.meth);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EnclosingMethod)) {
            return false;
        }
        EnclosingMethod other = (EnclosingMethod)obj;
        return this.clazz == other.clazz && this.meth == other.meth;
    }

    public int hashCode() {
        return this.meth * this.clazz;
    }

    @Override
    public int compareTo(EnclosingMethod o) {
        if (this.clazz < o.clazz) {
            return -1;
        }
        if (this.clazz > o.clazz) {
            return 1;
        }
        if (this.meth < o.meth) {
            return -1;
        }
        if (this.meth > o.meth) {
            return 1;
        }
        return 0;
    }
}

