/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.zinutils.bytecode.ByteCodeInspector;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;

public class ConstPool {
    private CPInfo[] pool;
    private int nextPoolEntry;

    public ConstPool() {
        this.pool = new CPInfo[10];
        this.nextPoolEntry = 1;
    }

    public ConstPool(int poolCount) {
        this.pool = new CPInfo[poolCount];
        this.nextPoolEntry = poolCount;
    }

    public CPInfo get(int idx) {
        return this.pool[idx];
    }

    public short addPoolEntry(CPInfo entry) {
        int ne = this.nextPoolEntry;
        if (entry instanceof CPInfo.DoubleEntry) {
            ++ne;
        }
        if (this.pool == null) {
            this.pool = new CPInfo[10];
        } else if (ne >= this.pool.length) {
            this.pool = Arrays.copyOf(this.pool, this.pool.length * 2);
        }
        short ret = (short)this.nextPoolEntry;
        this.pool[this.nextPoolEntry++] = entry;
        if (entry instanceof CPInfo.DoubleEntry) {
            ++this.nextPoolEntry;
        }
        return ret;
    }

    void showPool(ByteCodeInspector.HexDumpStream hexdump) {
        ArrayList<String> output = new ArrayList<String>();
        for (int idx = 1; idx < this.pool.length; ++idx) {
            output.add(this.pool[idx].asClean());
        }
        Collections.sort(output);
        for (String s : output) {
            hexdump.print(s);
        }
    }

    public void setPoolEntry(int idx, CPInfo readPoolEntry) {
        this.pool[idx] = readPoolEntry;
    }

    public void writeConstantPool(DataOutputStream dos) throws IOException {
        dos.writeShort(this.nextPoolEntry);
        for (int idx = 1; idx < this.nextPoolEntry; ++idx) {
            if (this.pool[idx] == null) continue;
            this.pool[idx].writeEntry(dos);
            if (!(this.pool[idx] instanceof CPInfo.DoubleEntry)) continue;
            ++idx;
        }
    }

    int requireClass(String string) {
        int i;
        String s = FileUtils.convertDottedToSlashPath(string);
        int utf8Idx = 0;
        for (i = 1; i < this.nextPoolEntry; ++i) {
            if (this.get(i) == null || !(this.get(i) instanceof CPInfo.Utf8Info) || !((CPInfo.Utf8Info)this.get(i)).asString().equals(s)) continue;
            utf8Idx = i;
            break;
        }
        if (utf8Idx > 0) {
            for (i = 1; i < this.nextPoolEntry; ++i) {
                if (this.get(i) == null || !(this.get(i) instanceof CPInfo.ClassInfo) || ((CPInfo.ClassInfo)this.get((int)i)).idx != utf8Idx) continue;
                return i;
            }
        } else {
            utf8Idx = this.nextPoolEntry + 1;
        }
        int clzIdx = this.nextPoolEntry;
        this.addPoolEntry(new CPInfo.ClassInfo(this, utf8Idx));
        this.addPoolEntry(new CPInfo.Utf8Info(s));
        return clzIdx;
    }

    public short requireInteger(int value) {
        for (short i = 1; i < this.nextPoolEntry; i = (short)((short)(i + 1))) {
            if (this.get(i) == null || !(this.get(i) instanceof CPInfo.IntegerInfo) || ((CPInfo.IntegerInfo)this.get(i)).value() != value) continue;
            return i;
        }
        return this.addPoolEntry(new CPInfo.IntegerInfo(value));
    }

    public int requireLong(long value) {
        for (int i = 1; i < this.nextPoolEntry; i = (int)((short)(i + 1))) {
            if (this.get(i) == null || !(this.get(i) instanceof CPInfo.LongInfo) || ((CPInfo.LongInfo)this.get(i)).value() != value) continue;
            return i;
        }
        return this.addPoolEntry(new CPInfo.LongInfo(value));
    }

    public short requireDouble(double value) {
        for (short i = 1; i < this.nextPoolEntry; i = (short)((short)(i + 1))) {
            if (this.get(i) == null || !(this.get(i) instanceof CPInfo.DoubleInfo) || ((CPInfo.DoubleInfo)this.get(i)).value() != value) continue;
            return i;
        }
        return this.addPoolEntry(new CPInfo.DoubleInfo(value));
    }

    public short requireUtf8(String name) {
        if (name == null) {
            throw new UtilException("Cannot have null name");
        }
        for (short i = 1; i < this.nextPoolEntry; i = (short)((short)(i + 1))) {
            if (this.get(i) == null || !(this.get(i) instanceof CPInfo.Utf8Info) || !((CPInfo.Utf8Info)this.get(i)).asString().equals(name)) continue;
            return i;
        }
        return this.addPoolEntry(new CPInfo.Utf8Info(name));
    }

    public int requireNT(int methIdx, int sigIdx) {
        for (int i = 1; i < this.nextPoolEntry; i = (int)((short)(i + 1))) {
            CPInfo.NTInfo nt;
            if (this.get(i) == null || !(this.get(i) instanceof CPInfo.NTInfo) || !(nt = (CPInfo.NTInfo)this.get(i)).isA(methIdx, sigIdx)) continue;
            return i;
        }
        return this.addPoolEntry(new CPInfo.NTInfo(this, methIdx, sigIdx));
    }

    public int requireRef(int refType, int clzIdx, int ntIdx) {
        for (int i = 1; i < this.nextPoolEntry; i = (int)((short)(i + 1))) {
            CPInfo.RefInfo r;
            if (this.get(i) == null || !(this.get(i) instanceof CPInfo.RefInfo) || !(r = (CPInfo.RefInfo)this.get(i)).isA(refType, clzIdx, ntIdx)) continue;
            return i;
        }
        return this.addPoolEntry(new CPInfo.RefInfo(this, clzIdx, ntIdx, refType));
    }

    public int requireString(String s) {
        int i;
        int utf8Idx = 0;
        for (i = 1; i < this.nextPoolEntry; ++i) {
            if (this.get(i) == null || !(this.get(i) instanceof CPInfo.Utf8Info) || !((CPInfo.Utf8Info)this.get(i)).asString().equals(s)) continue;
            utf8Idx = i;
            break;
        }
        if (utf8Idx > 0) {
            for (i = 1; i < this.nextPoolEntry; ++i) {
                if (this.get(i) == null || !(this.get(i) instanceof CPInfo.StringInfo) || ((CPInfo.StringInfo)this.get((int)i)).idx != utf8Idx) continue;
                return i;
            }
        } else {
            utf8Idx = this.nextPoolEntry + 1;
        }
        int strIdx = this.nextPoolEntry;
        this.addPoolEntry(new CPInfo.StringInfo(this, utf8Idx));
        this.addPoolEntry(new CPInfo.Utf8Info(s));
        if (strIdx == 0) {
            throw new UtilException("StrIdx == 0");
        }
        return strIdx;
    }

    public int size() {
        return this.nextPoolEntry;
    }

    public <T extends CPInfo> Iterable<Map.Entry<Integer, T>> entries(Class<T> cls) {
        TreeMap<Integer, CPInfo> ret = new TreeMap<Integer, CPInfo>();
        for (int i = 1; i < this.size(); ++i) {
            if (this.pool[i] == null || !cls.isInstance(this.pool[i])) continue;
            ret.put(i, this.pool[i]);
        }
        return ret.entrySet();
    }
}

