/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.StringConstExpr;
import org.zinutils.exceptions.UtilException;

public class ConcatExpr
extends Expr {
    private final List<Expr> args = new ArrayList<Expr>();

    public ConcatExpr(MethodDefiner meth, Object[] args) {
        super(meth);
        for (Object o : args) {
            if (o instanceof Expr) {
                this.args.add((Expr)o);
                continue;
            }
            if (o instanceof String) {
                this.args.add(new StringConstExpr(meth, (String)o));
                continue;
            }
            throw new UtilException("It is not currently possible to pass a " + o.getClass() + " directly to concat");
        }
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        String string = "java.lang.String";
        String stringBuilder = "java.lang.StringBuilder";
        meth.newObject(stringBuilder);
        meth.dup();
        boolean first = true;
        for (Expr o : this.args) {
            o.spitOutByteCode(meth);
            if (first) {
                if (!o.getType().equals(string)) {
                    meth.invokeVirtualMethod(o.getType(), string, "toString", new String[0]);
                }
                meth.invokeOtherConstructor(stringBuilder, string);
            } else {
                String atype = "java.lang.Object";
                if (o.getType().equals(string)) {
                    atype = o.getType();
                }
                meth.invokeVirtualMethod(stringBuilder, stringBuilder, "append", atype);
            }
            first = false;
        }
        meth.invokeVirtualMethod(stringBuilder, string, "toString", new String[0]);
    }

    @Override
    public String getType() {
        return "java.lang.String";
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        boolean hasOne = false;
        for (Expr e : this.args) {
            if (hasOne) {
                sb.append(" + ");
            }
            hasOne = true;
            e.asSource(sb, lnt, ind, false);
        }
    }
}

