/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.util.List;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.bytecode.ConstPool;
import org.zinutils.bytecode.JavaInfo;

public class ClassPoolEntry {
    private final ConstPool pool;
    private final int idx;

    public ClassPoolEntry(CPInfo.ClassInfo info) {
        this.idx = info.idx;
        this.pool = info.pool;
    }

    public ClassPoolEntry(CPInfo.NTInfo info) {
        this.idx = info.descriptor;
        this.pool = info.pool;
    }

    public String getName() {
        return ((CPInfo.Utf8Info)this.pool.get(this.idx)).asClean();
    }

    public void setName(String rw) {
        this.pool.setPoolEntry(this.idx, new CPInfo.Utf8Info(rw));
    }

    public List<String> getReferencedClasses() {
        String sig = ((CPInfo.Utf8Info)this.pool.get(this.idx)).asClean();
        List<String> ret = sig.startsWith("(") ? JavaInfo.unmapSignature(sig, false) : JavaInfo.simplify(sig);
        return ret;
    }

    public String toString() {
        return "CPE[" + this.idx + ":" + this.pool.get(this.idx).asClean() + "]";
    }
}

