/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;

public class CastToExpr
extends Expr {
    private final IExpr expr;
    private final String newType;

    public CastToExpr(MethodDefiner meth, IExpr expr, String newType) {
        super(meth);
        this.expr = expr;
        this.newType = newType;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        this.expr.spitOutByteCode(meth);
        meth.checkCast(this.newType);
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        sb.append("(");
        sb.append("(");
        sb.append(this.newType);
        sb.append(")");
        this.expr.asSource(sb, lnt, ind + 2, true);
        sb.append(")");
    }

    @Override
    public String getType() {
        return this.newType;
    }
}

