/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.bouncycastle.util.Arrays;
import org.zinutils.bytecode.ConstPool;
import org.zinutils.exceptions.UtilException;

public abstract class CPInfo {
    protected final ConstPool pool;
    protected final int idx;

    public CPInfo() {
        this.pool = null;
        this.idx = 0;
    }

    public CPInfo(ConstPool pool, int idx) {
        this.pool = pool;
        this.idx = idx;
    }

    private String hex(int val) {
        return val + "/#" + Integer.toHexString(val);
    }

    public String toString() {
        if (this.pool != null && this.pool.get(this.idx) != null) {
            return this.getClass().getSimpleName() + "[" + this.hex(this.idx) + "] " + this.pool.get(this.idx).toString();
        }
        return super.toString();
    }

    public abstract void writeEntry(DataOutputStream var1) throws IOException;

    public abstract String asClean();

    public static class InvokeDynamicInfo
    extends CPInfo {
        private final int bootstrapMethod;
        final int ntidx;

        public InvokeDynamicInfo(ConstPool pool, int bsm, int ntidx) {
            super(pool, 0);
            this.bootstrapMethod = bsm;
            this.ntidx = ntidx;
        }

        @Override
        public String toString() {
            String s = this.getClass().getSimpleName() + "[" + super.hex(this.bootstrapMethod) + "," + super.hex(this.ntidx) + "] {" + this.pool.get(this.bootstrapMethod) + " " + this.pool.get(this.ntidx) + "}";
            return s;
        }

        @Override
        public String asClean() {
            return this.toString();
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(18);
            dos.writeShort(this.bootstrapMethod);
            dos.writeShort(this.ntidx);
        }
    }

    public static class MTInfo
    extends CPInfo {
        final int didx;

        public MTInfo(ConstPool pool, int didx) {
            super(pool, 0);
            this.didx = didx;
        }

        @Override
        public String toString() {
            String s = this.getClass().getSimpleName() + "[" + super.hex(this.didx) + "] {" + this.pool.get(this.didx) + "}";
            return s;
        }

        @Override
        public String asClean() {
            return this.toString();
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(16);
            dos.writeShort(this.didx);
        }
    }

    public static class MHInfo
    extends CPInfo {
        private final int kind;
        final int ridx;

        public MHInfo(ConstPool pool, int kind, int ridx) {
            super(pool, 0);
            this.kind = kind;
            this.ridx = ridx;
        }

        @Override
        public String toString() {
            String s = this.getClass().getSimpleName() + "[" + super.hex(this.kind) + "," + super.hex(this.ridx) + "] {" + this.kind + ": " + this.pool.get(this.ridx) + "}";
            return s;
        }

        @Override
        public String asClean() {
            return this.toString();
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(15);
            dos.writeByte(this.kind);
            dos.writeShort(this.ridx);
        }
    }

    public static class NTInfo
    extends CPInfo {
        private final int name;
        final int descriptor;

        public NTInfo(ConstPool pool, int name, int descriptor) {
            super(pool, 0);
            this.name = name;
            this.descriptor = descriptor;
        }

        public String nameDescriptor() {
            return this.pool.get(this.name).asClean() + this.justDescriptorName();
        }

        @Override
        public String toString() {
            String s = this.getClass().getSimpleName() + "[" + super.hex(this.name) + "," + super.hex(this.descriptor) + "] {" + this.pool.get(this.name) + " " + this.pool.get(this.descriptor) + "}";
            return s;
        }

        @Override
        public String asClean() {
            return this.toString();
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(12);
            dos.writeShort(this.name);
            dos.writeShort(this.descriptor);
        }

        public boolean isA(int methIdx, int sigIdx) {
            return this.name == methIdx && this.descriptor == sigIdx;
        }

        public boolean matches(String name, String sig) {
            return ((Utf8Info)this.pool.get(this.name)).matches(name) && ((Utf8Info)this.pool.get(this.descriptor)).matches(sig);
        }

        public String justDescriptorName() {
            return this.pool.get(this.descriptor).asClean();
        }

        public void setDescriptorName(String rw) {
            this.pool.setPoolEntry(this.descriptor, new Utf8Info(rw));
        }
    }

    public static class RefInfo
    extends CPInfo {
        private final int tag;
        private final int clz;
        private final int nt;

        public RefInfo(ConstPool pool, int clz, int nt, int tag) {
            super(pool, 0);
            this.clz = clz;
            this.nt = nt;
            this.tag = tag;
        }

        @Override
        public String asClean() {
            if (this.tag == 9) {
                NTInfo cpInfo = (NTInfo)this.pool.get(this.nt);
                return "F" + this.pool.get(this.clz).asClean() + "." + this.pool.get(cpInfo.name).asClean() + "{" + this.pool.get(cpInfo.descriptor).asClean() + "}";
            }
            if (this.tag == 10 || this.tag == 11) {
                String cm = "M";
                if (this.tag == 11) {
                    cm = "I";
                }
                NTInfo cpInfo = (NTInfo)this.pool.get(this.nt);
                return cm + this.pool.get(this.clz).asClean() + "." + this.pool.get(cpInfo.name).asClean() + " " + this.pool.get(cpInfo.descriptor).asClean();
            }
            throw new UtilException("No");
        }

        @Override
        public String toString() {
            String s = this.tagAsString() + this.getClass().getSimpleName() + "[" + super.hex(this.clz) + "," + super.hex(this.nt) + "] {" + this.pool.get(this.clz) + " " + this.pool.get(this.nt) + "}";
            return s;
        }

        private String tagAsString() {
            if (this.tag == 9) {
                return "Field";
            }
            if (this.tag == 10) {
                return "Method";
            }
            if (this.tag == 11) {
                return "Interface";
            }
            throw new UtilException("Unspecified tag " + this.tag);
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(this.tag);
            dos.writeShort(this.clz);
            dos.writeShort(this.nt);
        }

        public boolean isA(int refType, int clzIdx, int sigIdx) {
            return this.tag == refType && this.clz == clzIdx && this.nt == sigIdx;
        }

        public boolean isMethod(String name, String sig) {
            if (this.tag != 10) {
                return false;
            }
            NTInfo nti = (NTInfo)this.pool.get(this.nt);
            return nti.matches(name, sig);
        }
    }

    public static class StringInfo
    extends CPInfo {
        public StringInfo(ConstPool pool, int idx) {
            super(pool, idx);
        }

        @Override
        public String toString() {
            return "StringInfo[" + this.idx + "{" + this.pool.get(this.idx) + "}]";
        }

        @Override
        public String asClean() {
            return "\"" + this.pool.get(this.idx).asClean() + "\"";
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(8);
            dos.writeShort(this.idx);
        }

        public String asString() {
            return this.pool.get(this.idx).asClean();
        }
    }

    public static class ClassInfo
    extends CPInfo {
        public ClassInfo(ConstPool pool, int idx) {
            super(pool, idx);
        }

        @Override
        public String toString() {
            return "ClassInfo[" + this.idx + "{" + this.pool.get(this.idx) + "}]";
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassInfo) {
                return ((ClassInfo)obj).idx == this.idx;
            }
            if (obj instanceof String) {
                return ((Utf8Info)this.pool.get((int)this.idx)).utf8.equals(obj);
            }
            return super.equals(obj);
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(7);
            dos.writeShort(this.idx);
        }

        @Override
        public String asClean() {
            return "Class[" + this.justName() + "]";
        }

        public String justName() {
            return ((Utf8Info)this.pool.get(this.idx)).asClean();
        }
    }

    public static class DoubleInfo
    extends CPInfo
    implements DoubleEntry {
        private double val;

        public DoubleInfo(double d) {
            this.val = d;
        }

        public double value() {
            return this.val;
        }

        @Override
        public String toString() {
            return "Double: " + this.val;
        }

        @Override
        public String asClean() {
            return Double.toString(this.val);
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(6);
            dos.writeDouble(this.val);
        }
    }

    public static class LongInfo
    extends CPInfo
    implements DoubleEntry {
        private long val;

        public LongInfo(long l) {
            this.val = l;
        }

        public LongInfo(int high, int low) {
            long l = high;
            this.val = l << 32 | (long)low;
        }

        public long value() {
            return this.val;
        }

        @Override
        public String toString() {
            return "Long: " + this.val;
        }

        @Override
        public String asClean() {
            return Long.toString(this.val);
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(5);
            dos.writeInt((int)(this.val >> 32));
            dos.writeInt((int)(this.val & 0xFFFFFFFL));
        }
    }

    public static class FloatInfo
    extends CPInfo {
        private float val;

        public FloatInfo(float f) {
            this.val = f;
        }

        public float value() {
            return this.val;
        }

        @Override
        public String toString() {
            return "Float: " + this.val;
        }

        @Override
        public String asClean() {
            return Float.toString(this.val);
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(4);
            dos.writeFloat(this.val);
        }
    }

    public static class IntegerInfo
    extends CPInfo {
        private final int val;

        public IntegerInfo(int i) {
            this.val = i;
        }

        public int value() {
            return this.val;
        }

        @Override
        public String toString() {
            return "Integer: " + this.val;
        }

        @Override
        public String asClean() {
            return Integer.toString(this.val);
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(3);
            dos.writeInt(this.val);
        }
    }

    public static class Utf8Info
    extends CPInfo {
        private final byte[] utf8;

        public Utf8Info(byte[] bytes) {
            this.utf8 = bytes;
        }

        public Utf8Info(String str) {
            if (str == null) {
                throw new UtilException("Cannot create UTF8 with null string");
            }
            this.utf8 = str.getBytes(Charset.forName("UTF-8"));
        }

        @Override
        public String toString() {
            return "U8: " + this.utf8;
        }

        @Override
        public String asClean() {
            return new String(this.utf8, Charset.forName("UTF-8"));
        }

        @Override
        public void writeEntry(DataOutputStream dos) throws IOException {
            dos.write(1);
            dos.writeShort(this.utf8.length);
            dos.write(this.utf8);
        }

        public String asString() {
            return new String(this.utf8, Charset.forName("UTF-8"));
        }

        public boolean matches(String compareTo) {
            byte[] bs = compareTo.getBytes(Charset.forName("UTF-8"));
            return Arrays.areEqual((byte[])this.utf8, (byte[])bs);
        }
    }

    public static interface DoubleEntry {
    }
}

