/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarOutputStream;
import org.zinutils.bytecode.ByteCodeCreator;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.ByteCodeHolder;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.exceptions.UtilException;

public class ByteCodeJar
implements ByteCodeHolder {
    private List<ByteCodeCreator> files = new ArrayList<ByteCodeCreator>();
    private final ByteCodeEnvironment env;

    public ByteCodeJar(ByteCodeEnvironment env) {
        this.env = env;
    }

    @Override
    public ByteCodeSink newEntry(String className, int destinations) {
        ByteCodeCreator ret = new ByteCodeCreator(this.env, className);
        this.addEntry(className, ret);
        return ret;
    }

    @Override
    public void addEntry(String className, ByteCodeCreator ret) {
        for (ByteCodeCreator bcc : this.files) {
            if (!bcc.getCreatedName().equals(className)) continue;
            throw new UtilException("Duplicated JAR entry: " + className);
        }
        this.files.add(ret);
    }

    public void write(File writeTo) {
        try {
            JarOutputStream jos = new JarOutputStream(new FileOutputStream(writeTo));
            for (ByteCodeCreator bcc : this.files) {
                bcc.addToJar(jos);
            }
            jos.close();
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public boolean hasEntries() {
        return !this.files.isEmpty();
    }

    public int entryCount() {
        return this.files.size();
    }

    @Override
    public void close() {
        this.files.clear();
    }
}

