/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.bytecode.ConstPool;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;
import org.zinutils.utils.StringUtil;

public class ByteCodeInspector
extends ByteCodeFile {
    private HexDumpStream hexdump;
    private boolean cleanMode;
    private boolean showPool;

    public static void main(String[] argv) {
        OutputStreamWriter writer = null;
        try {
            ByteCodeInspector bci = new ByteCodeInspector();
            ArrayList<String> args = new ArrayList<String>();
            for (String s : argv) {
                if (s.equals("--clean")) {
                    bci.cleanMode = true;
                    continue;
                }
                if (s.equals("--pool")) {
                    bci.showPool = true;
                    continue;
                }
                if (s.startsWith("-")) {
                    throw new UtilException("Unknown argument: " + s);
                }
                args.add(s);
            }
            if (args.size() < 1) {
                System.out.println("Usage: inspector [--clean] [--pool] <class> ...");
                return;
            }
            writer = new OutputStreamWriter(new FileOutputStream("dumpClass.txt"));
            for (String s : args) {
                InputStream fis;
                if (args.size() > 1) {
                    writer.append(" ======= " + s + "\n");
                }
                if ((fis = ByteCodeInspector.class.getResourceAsStream(s)) == null) {
                    fis = new FileInputStream(s);
                }
                bci.read(new PrintWriter(writer), fis);
                fis.close();
            }
            writer.close();
            FileUtils.cat(new File("dumpClass.txt"));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.out);
            System.exit(1);
        }
        catch (Exception ex) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            FileUtils.cat(new File("dumpClass.txt"));
            ex.printStackTrace(System.out);
            System.exit(2);
        }
    }

    public ByteCodeInspector() {
    }

    public ByteCodeInspector(boolean clean) {
        this.cleanMode = clean;
    }

    public void read(PrintWriter out, InputStream fis) {
        try {
            this.hexdump = new HexDumpStream(this.cleanMode, out, fis);
            DataInputStream dis = new DataInputStream(this.hexdump);
            int magic = dis.readInt();
            if (magic != -889275714) {
                throw new UtilException("This is not a bytecode file");
            }
            if (!this.cleanMode) {
                this.hexdump.print("Magic: " + magic);
            }
            int minorVersion = dis.readUnsignedShort();
            int majorVersion = dis.readUnsignedShort();
            if (!this.cleanMode) {
                this.hexdump.print("Version: " + majorVersion + "-" + minorVersion);
            }
            this.readConstantPool(dis);
            if (this.showPool) {
                this.pool.showPool(this.hexdump);
            }
            int access = dis.readUnsignedShort();
            if (!this.cleanMode) {
                this.hexdump.print("Access = " + access);
            }
            int thisClass = dis.readUnsignedShort();
            if (this.cleanMode) {
                String isA = "class";
                if ((access & 0x200) == 512) {
                    isA = "interface";
                } else if ((access & 0x400) == 1024) {
                    isA = "abstract class";
                }
                this.hexdump.print(isA + " " + ((CPInfo.ClassInfo)this.pool.get(thisClass)).justName());
            } else {
                this.hexdump.print("This = " + this.show(thisClass));
            }
            int superClass = dis.readUnsignedShort();
            if (this.cleanMode) {
                this.hexdump.print("  extends " + ((CPInfo.ClassInfo)this.pool.get(superClass)).justName());
            } else {
                this.hexdump.print("Super = " + this.show(superClass));
            }
            this.readInterfaces(dis);
            this.readFields(dis);
            this.readMethods(dis);
            this.readAttributes(dis, "Class");
        }
        catch (Exception ex) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw UtilException.wrap(ex);
        }
    }

    private void readConstantPool(DataInputStream dis) throws IOException {
        int poolCount = dis.readUnsignedShort();
        this.pool = new ConstPool(poolCount);
        if (!this.cleanMode) {
            this.hexdump.print("pool has " + poolCount + " entries, including #0");
        }
        for (int idx = 1; idx < poolCount; ++idx) {
            CPInfo entry = this.readPoolEntry(dis);
            this.pool.setPoolEntry(idx, entry);
            if (!this.cleanMode) {
                this.hexdump.print(idx + " => " + entry);
            }
            if (!(entry instanceof CPInfo.DoubleEntry)) continue;
            if (!this.cleanMode) {
                this.hexdump.print("****");
            }
            ++idx;
        }
    }

    private void readInterfaces(DataInputStream dis) throws IOException {
        int cnt = dis.readUnsignedShort();
        if (!this.cleanMode) {
            this.hexdump.print(cnt + " interfaces");
        }
        for (int i = 0; i < cnt; ++i) {
            int idx = dis.readUnsignedShort();
            this.interfaces.add(idx);
            CPInfo.ClassInfo intf = (CPInfo.ClassInfo)this.pool.get(idx);
            if (this.cleanMode) {
                this.hexdump.print("  implements " + intf.justName());
                continue;
            }
            this.hexdump.print(intf);
        }
    }

    private void readFields(DataInputStream dis) throws IOException {
        int cnt = dis.readUnsignedShort();
        if (!this.cleanMode) {
            this.hexdump.print("# of fields = " + cnt);
        }
        for (int i = 0; i < cnt; ++i) {
            int access = dis.readUnsignedShort();
            int name = dis.readUnsignedShort();
            int descriptor = dis.readUnsignedShort();
            this.hexdump.print("Field" + this.flags(access) + this.show(descriptor) + " " + this.show(name));
            this.readAttributes(dis, "Field");
        }
    }

    private void readMethods(DataInputStream dis) throws IOException {
        int cnt = dis.readUnsignedShort();
        if (!this.cleanMode) {
            this.hexdump.print("# of methods = " + cnt);
        }
        for (int i = 0; i < cnt; ++i) {
            int access = dis.readUnsignedShort();
            int name = dis.readUnsignedShort();
            int descriptor = dis.readUnsignedShort();
            this.hexdump.print("Method" + this.flags(access) + this.show(name) + " " + this.show(descriptor));
            this.readAttributes(dis, "Method");
        }
    }

    private String flags(int access) {
        StringBuilder sb = new StringBuilder(" ");
        if ((access & 0x400) != 0) {
            sb.append("abstract ");
            access &= 0xFFFFFBFF;
        }
        if ((access & 0x10) != 0) {
            sb.append("final ");
            access &= 0xFFFFFFEF;
        }
        if ((access & 0x200) != 0) {
            sb.append("interface ");
            access &= 0xFFFFFDFF;
        }
        if ((access & 0x100) != 0) {
            sb.append("native ");
            access &= 0xFFFFFEFF;
        }
        if ((access & 2) != 0) {
            sb.append("private ");
            access &= 0xFFFFFFFD;
        }
        if ((access & 4) != 0) {
            sb.append("protected ");
            access &= 0xFFFFFFFB;
        }
        if ((access & 1) != 0) {
            sb.append("public ");
            access &= 0xFFFFFFFE;
        }
        if ((access & 8) != 0) {
            sb.append("static ");
            access &= 0xFFFFFFF7;
        }
        if ((access & 0x800) != 0) {
            sb.append("strict ");
            access &= 0xFFFFF7FF;
        }
        if ((access & 0x20) != 0) {
            sb.append("super ");
            access &= 0xFFFFFFDF;
        }
        if ((access & 0x20) != 0) {
            sb.append("synchronized ");
            access &= 0xFFFFFFDF;
        }
        if ((access & 0x80) != 0) {
            sb.append("transient ");
            access &= 0xFFFFFF7F;
        }
        if ((access & 0x1000) != 0) {
            sb.append("access ");
            access &= 0xFFFFEFFF;
        }
        if ((access & 0x4000) != 0) {
            sb.append("enum ");
            access &= 0xFFFFBFFF;
        }
        if ((access & 0x40) != 0) {
            sb.append("bridge ");
            access &= 0xFFFFFFBF;
        }
        if (access != 0) {
            sb.append(" !!!! [" + access + "]");
        }
        return sb.toString();
    }

    private String show(int name) {
        if (this.cleanMode) {
            return this.pool.get(name).asClean();
        }
        return this.pool.get(name).toString();
    }

    private String show(CPInfo info) {
        if (this.cleanMode) {
            return info.asClean();
        }
        return info.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void readAttributes(DataInputStream dis, String type) throws IOException {
        int cnt = dis.readUnsignedShort();
        if (!this.cleanMode) {
            this.hexdump.print(type + " attributes: " + cnt);
        }
        for (int i = 0; i < cnt; ++i) {
            int idx = dis.readUnsignedShort();
            int len = dis.readInt();
            if (len > 5000) {
                throw new RuntimeException("What? Attribute Len > 5000 (" + StringUtil.hex(len, 8) + ")");
            }
            if (!this.cleanMode) {
                this.hexdump.print("idx = " + idx + ": " + this.pool.get(idx) + " len=" + len);
            }
            if (this.pool.get(idx) == null || !(this.pool.get(idx) instanceof CPInfo.Utf8Info)) {
                throw new UtilException("Invalid attribute: " + idx);
            }
            String attr = ((CPInfo.Utf8Info)this.pool.get(idx)).asString();
            if (attr.equals("Code")) {
                void var11_32;
                int maxStack = dis.readUnsignedShort();
                int maxLocals = dis.readUnsignedShort();
                int codeLength = dis.readInt();
                if (this.cleanMode) {
                    this.hexdump.append("  ");
                }
                this.hexdump.print("maxStack = " + maxStack + " maxLocals = " + maxLocals + " codeLen = " + codeLength);
                if (this.cleanMode) {
                    this.hexdump.print("  {");
                }
                boolean bl = false;
                while (var11_32 < codeLength) {
                    if (this.cleanMode) {
                        this.hexdump.append("    ");
                    }
                    this.hexdump.append(StringUtil.hex((long)var11_32, 4) + ": ");
                    var11_32 += this.disassemble(dis, (int)var11_32);
                }
                if (this.cleanMode) {
                    this.hexdump.print("  }");
                }
                int excLength = dis.readUnsignedShort();
                if (!this.cleanMode) {
                    this.hexdump.print(excLength + " exceptions");
                }
                for (int j = 0; j < excLength; ++j) {
                    int start_pc = dis.readUnsignedShort();
                    int end_pc = dis.readUnsignedShort();
                    int handler_pc = dis.readUnsignedShort();
                    int catch_type = dis.readUnsignedShort();
                    this.hexdump.print("Catch " + (catch_type == 0 ? "finally" : this.show(catch_type)) + " in " + start_pc + "-" + end_pc + " and handle in " + handler_pc);
                }
                this.readAttributes(dis, "Code");
                continue;
            }
            if (attr.equals("Signature") || attr.equals("SourceFile")) {
                if (len != 2) {
                    throw new UtilException("Attribute has incorrect length: " + attr + ": length = " + len);
                }
                int ai = dis.readUnsignedShort();
                this.hexdump.print("[" + type + " " + attr + "]: " + this.show(ai));
                continue;
            }
            if (attr.equals("Exceptions")) {
                byte[] data = new byte[len];
                this.readBytes(dis, data);
                for (int j = 2; j < data.length; j += 2) {
                    int ex = this.getDataShort(data, j);
                    this.hexdump.print("throws exception " + this.pool.get(ex).asClean());
                }
                continue;
            }
            if (attr.equals("RuntimeVisibleAnnotations") || attr.equals("RuntimeInvisibleAnnotations")) {
                int acnt = dis.readUnsignedShort();
                this.hexdump.print("Attribute for " + type + " has " + acnt + " annotations in " + attr);
                for (int rva = 0; rva < acnt; ++rva) {
                    this.readAnnotation(dis);
                }
                continue;
            }
            if (attr.equals("RuntimeVisibleParameterAnnotations")) {
                int nparams = dis.readUnsignedByte();
                this.hexdump.print("Has " + nparams + " parameter annotations");
                for (int np = 0; np < nparams; ++np) {
                    int acnt = dis.readUnsignedShort();
                    this.hexdump.print("Parameter " + np + " has " + acnt + " annotations");
                    for (int j = 0; j < acnt; ++j) {
                        this.readAnnotation(dis);
                    }
                }
                continue;
            }
            if (attr.equals("InnerClasses")) {
                int refersTo = dis.readUnsignedShort();
                this.hexdump.print(refersTo + " inner classes");
                ArrayList<CallSite> output = new ArrayList<CallSite>();
                for (int j = 0; j < refersTo; ++j) {
                    int n = dis.readUnsignedShort();
                    int oc = dis.readUnsignedShort();
                    int in = dis.readUnsignedShort();
                    int acc = dis.readUnsignedShort();
                    String out = "Ref" + this.flags(acc) + this.show(n) + " <= " + (oc == 0 ? "" : this.show(oc)) + "." + (in == 0 ? "" : this.show(in));
                    if (this.cleanMode) {
                        output.add((CallSite)((Object)out));
                        continue;
                    }
                    this.hexdump.print(out);
                }
                if (!this.cleanMode) continue;
                Collections.sort(output);
                for (String string : output) {
                    this.hexdump.print(string);
                }
                continue;
            }
            if (attr.equals("EnclosingMethod")) {
                void var11_38;
                int ci = dis.readUnsignedShort();
                int mi = dis.readUnsignedShort();
                CPInfo.ClassInfo clz = (CPInfo.ClassInfo)this.pool.get(ci);
                String string = "";
                if (mi != 0) {
                    CPInfo.NTInfo mt = (CPInfo.NTInfo)this.pool.get(mi);
                    String string2 = "." + mt.nameDescriptor();
                }
                this.hexdump.print("EnclosingMethod: " + clz.justName() + (String)var11_38);
                continue;
            }
            if (attr.equals("StackMapTable")) {
                int nentries = dis.readUnsignedShort();
                this.hexdump.print(nentries + " stack map entries");
                for (int ei = 0; ei < nentries; ++ei) {
                    int n;
                    int what = dis.readUnsignedByte();
                    if (what < 64) {
                        this.hexdump.print("  same_frame; offset = " + StringUtil.hex(what, 2));
                        continue;
                    }
                    if (what < 128) {
                        this.hexdump.print("  same_frame, 1 local; offset = " + StringUtil.hex(what - 64, 2));
                        this.readVerificationTypeInfo(dis);
                        continue;
                    }
                    if (what >= 248 && what <= 250) {
                        n = dis.readUnsignedShort();
                        this.hexdump.print("  chop_frame(" + (251 - what) + "); offset = " + StringUtil.hex(n, 2));
                        continue;
                    }
                    if (what == 251) {
                        n = dis.readUnsignedShort();
                        this.hexdump.print("  same_frame_extended; offset = " + StringUtil.hex(n, 2));
                        continue;
                    }
                    if (what >= 252 && what <= 254) {
                        n = dis.readUnsignedShort();
                        this.hexdump.print("  append_frame: " + StringUtil.hex(what, 2) + "; offset = " + StringUtil.hex(n, 4));
                        for (int f = 252; f <= what; ++f) {
                            this.readVerificationTypeInfo(dis);
                        }
                        continue;
                    }
                    if (what == 255) {
                        n = dis.readUnsignedShort();
                        int numLocals = dis.readUnsignedShort();
                        this.hexdump.print("  full_frame: offset = " + StringUtil.hex(n, 4) + "; #locals = " + numLocals);
                        for (int f = 0; f < numLocals; ++f) {
                            this.readVerificationTypeInfo(dis);
                        }
                        int numFrame = dis.readUnsignedShort();
                        this.hexdump.print("   #frames = " + numFrame);
                        for (int f = 0; f < numFrame; ++f) {
                            this.readVerificationTypeInfo(dis);
                        }
                        continue;
                    }
                    throw new UtilException("Not handled; see http://docs.oracle.com/javase/specs/jvms/se8/html/jvms-4.html#jvms-4.7.4; what = " + StringUtil.hex(what, 2));
                }
                continue;
            }
            if (attr.equals("LineNumberTable")) {
                int nlines = dis.readUnsignedShort();
                this.hexdump.print(nlines + " Line Number Entries");
                for (int j = 0; j < nlines; ++j) {
                    int codePtr = dis.readUnsignedShort();
                    int n = dis.readUnsignedShort();
                    this.hexdump.print("Line " + n + ": " + codePtr);
                }
                continue;
            }
            if (attr.equals("LocalVariableTable")) {
                int nvars = dis.readUnsignedShort();
                for (int j = 0; j < nvars; ++j) {
                    int startPc = dis.readUnsignedShort();
                    int n = dis.readUnsignedShort();
                    String name = this.pool.get(dis.readUnsignedShort()).asClean();
                    String sig = this.pool.get(dis.readUnsignedShort()).asClean();
                    int varLoc = dis.readUnsignedShort();
                    this.hexdump.print(sig + " " + name + " (var #" + varLoc + " from " + startPc + " to " + (startPc + n) + ")");
                }
                continue;
            }
            byte[] bytes = new byte[len];
            this.readBytes(dis, bytes);
            if (this.cleanMode) {
                this.hexdump.print(type + " attribute " + this.pool.get(idx).asClean() + "[" + len + "]");
                continue;
            }
            this.hexdump.print("");
        }
    }

    private void readVerificationTypeInfo(DataInputStream dis) throws IOException {
        int tag = dis.readUnsignedByte();
        if (tag == 0) {
            this.hexdump.print("    introduced var with constraint 'top'");
        } else if (tag == 1) {
            this.hexdump.print("    introduced var of type int");
        } else if (tag == 7) {
            int pi = dis.readUnsignedShort();
            CPInfo.ClassInfo ci = (CPInfo.ClassInfo)this.pool.get(pi);
            this.hexdump.print("    introduced var of type " + this.show(ci));
        } else {
            throw new UtilException("Cannot handle verification frame " + tag);
        }
    }

    private void readAnnotation(DataInputStream dis) throws IOException {
        int a = dis.readUnsignedShort();
        this.hexdump.print("@" + this.pool.get(a).asClean());
        int nvp = dis.readUnsignedShort();
        this.hexdump.print(nvp + " arguments");
        for (int rvp = 0; rvp < nvp; ++rvp) {
            int n = dis.readUnsignedShort();
            this.hexdump.append("  " + this.pool.get(n).asClean() + "=");
            this.readElementValue(dis);
        }
    }

    private void readElementValue(DataInputStream dis) throws IOException {
        char tag = (char)dis.readUnsignedByte();
        switch (tag) {
            case 'c': {
                int offset = dis.readUnsignedShort();
                this.hexdump.print(this.pool.get(offset).asClean() + ".class");
                break;
            }
            case 's': {
                int offset = dis.readUnsignedShort();
                this.hexdump.print("\"" + this.pool.get(offset).asClean() + "\"");
                break;
            }
            case 'Z': {
                int offset = dis.readUnsignedShort();
                this.hexdump.print(this.pool.get(offset).asClean());
                break;
            }
            case '[': {
                int arrSize = dis.readUnsignedShort();
                this.hexdump.print("[");
                for (int ai = 0; ai < arrSize; ++ai) {
                    this.readElementValue(dis);
                }
                this.hexdump.print("]");
                break;
            }
            case '@': {
                this.readAnnotation(dis);
                break;
            }
            case 'e': {
                int clz = dis.readUnsignedShort();
                int val = dis.readUnsignedShort();
                this.hexdump.print(this.pool.get(clz).asClean() + "." + this.pool.get(val).asClean());
                break;
            }
            default: {
                throw new UtilException("The attribute value tag " + tag + " is not supported");
            }
        }
    }

    private int getDataShort(byte[] data, int j) {
        int msb = data[j] & 0xFF;
        int lsb = data[j + 1] & 0xFF;
        return msb << 8 | lsb;
    }

    private int disassemble(DataInputStream dis, int offset) throws IOException {
        int opcode = dis.readUnsignedByte();
        switch (opcode) {
            case 1: {
                this.hexdump.print("aconst_null");
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.hexdump.print("iconst_" + (opcode - 3));
                return 1;
            }
            case 9: 
            case 10: {
                this.hexdump.print("lconst_" + (opcode - 9));
                return 1;
            }
            case 11: 
            case 12: 
            case 13: {
                this.hexdump.print("fconst_" + (opcode - 11));
                return 1;
            }
            case 14: 
            case 15: {
                this.hexdump.print("dconst_" + (opcode - 14));
                return 1;
            }
            case 16: {
                byte bi = dis.readByte();
                this.hexdump.print("bipush " + bi);
                return 2;
            }
            case 17: {
                short si = dis.readShort();
                this.hexdump.print("sipush " + si);
                return 3;
            }
            case 18: {
                int idx = dis.readUnsignedByte();
                this.hexdump.print("ldc " + this.show(idx));
                return 2;
            }
            case 19: {
                int idx = dis.readUnsignedShort();
                this.hexdump.print("ldc_w " + this.show(idx));
                return 3;
            }
            case 20: {
                int idx = dis.readUnsignedShort();
                this.hexdump.print("ldc2_w " + this.show(idx));
                return 3;
            }
            case 21: {
                int reg = dis.readUnsignedByte();
                this.hexdump.print("iload " + reg);
                return 2;
            }
            case 24: {
                int reg = dis.readUnsignedByte();
                this.hexdump.print("dload " + reg);
                return 2;
            }
            case 25: {
                int reg = dis.readUnsignedByte();
                this.hexdump.print("aload " + reg);
                return 2;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.hexdump.print("iload_" + (opcode - 26));
                return 1;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.hexdump.print("lload_" + (opcode - 30));
                return 1;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.hexdump.print("dload_" + (opcode - 38));
                return 1;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.hexdump.print("aload_" + (opcode - 42));
                return 1;
            }
            case 50: {
                this.hexdump.print("aaload");
                return 1;
            }
            case 52: {
                this.hexdump.print("caload");
                return 1;
            }
            case 54: {
                int reg = dis.readUnsignedByte();
                this.hexdump.print("istore " + reg);
                return 2;
            }
            case 55: {
                int reg = dis.readUnsignedByte();
                this.hexdump.print("lstore " + reg);
                return 2;
            }
            case 58: {
                int reg = dis.readUnsignedByte();
                this.hexdump.print("astore " + reg);
                return 2;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.hexdump.print("istore_" + (opcode - 59));
                return 1;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.hexdump.print("lstore_" + (opcode - 63));
                return 1;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.hexdump.print("fstore_" + (opcode - 67));
                return 1;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.hexdump.print("dstore_" + (opcode - 71));
                return 1;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.hexdump.print("astore_" + (opcode - 75));
                return 1;
            }
            case 83: {
                this.hexdump.print("aastore");
                return 1;
            }
            case 85: {
                this.hexdump.print("castore");
                return 1;
            }
            case 87: {
                this.hexdump.print("pop");
                return 1;
            }
            case 88: {
                this.hexdump.print("pop2");
                return 1;
            }
            case 89: {
                this.hexdump.print("dup");
                return 1;
            }
            case 90: {
                this.hexdump.print("dup_x1");
                return 1;
            }
            case 91: {
                this.hexdump.print("dup_x2");
                return 1;
            }
            case 92: {
                this.hexdump.print("dup2");
                return 1;
            }
            case 93: {
                this.hexdump.print("dup2_x1");
                return 1;
            }
            case 94: {
                this.hexdump.print("dup2_x2");
                return 1;
            }
            case 95: {
                this.hexdump.print("swap");
                return 1;
            }
            case 96: {
                this.hexdump.print("iadd");
                return 1;
            }
            case 100: {
                this.hexdump.print("isub");
                return 1;
            }
            case 101: {
                this.hexdump.print("lsub");
                return 1;
            }
            case 102: {
                this.hexdump.print("fsub");
                return 1;
            }
            case 103: {
                this.hexdump.print("dsub");
                return 1;
            }
            case 104: {
                this.hexdump.print("imul");
                return 1;
            }
            case 105: {
                this.hexdump.print("lmul");
                return 1;
            }
            case 106: {
                this.hexdump.print("fmul");
                return 1;
            }
            case 107: {
                this.hexdump.print("dmul");
                return 1;
            }
            case 108: {
                this.hexdump.print("idiv");
                return 1;
            }
            case 122: {
                this.hexdump.print("ishr");
                return 1;
            }
            case 126: {
                this.hexdump.print("iand");
                return 1;
            }
            case 128: {
                this.hexdump.print("ior");
                return 1;
            }
            case 130: {
                this.hexdump.print("ixor");
                return 1;
            }
            case 132: {
                int idx = dis.readUnsignedByte();
                int c = dis.readUnsignedByte();
                this.hexdump.print("iinc v" + idx + " " + c);
                return 3;
            }
            case 133: {
                this.hexdump.print("i2l");
                return 1;
            }
            case 136: {
                this.hexdump.print("l2i");
                return 1;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                String op = "if" + (new String[]{"eq", "ne", "lt", "ge", "gt", "le"})[opcode - 153];
                short jumpTo = dis.readShort();
                this.hexdump.print(op + " " + StringUtil.hex(offset + jumpTo, 4));
                return 3;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                String op = "if_icmp" + (new String[]{"eq", "ne", "lt", "ge", "gt", "le"})[opcode - 159];
                short jumpTo = dis.readShort();
                this.hexdump.print(op + " " + StringUtil.hex(offset + jumpTo, 4));
                return 3;
            }
            case 165: 
            case 166: {
                String op = "if_acmp" + (new String[]{"eq", "ne"})[opcode - 165];
                short jumpTo = dis.readShort();
                this.hexdump.print(op + " " + StringUtil.hex(offset + jumpTo, 4));
                return 3;
            }
            case 167: {
                short jumpTo = dis.readShort();
                this.hexdump.print("goto " + StringUtil.hex(offset + jumpTo, 4));
                return 3;
            }
            case 172: {
                this.hexdump.print("ireturn");
                return 1;
            }
            case 173: {
                this.hexdump.print("lreturn");
                return 1;
            }
            case 175: {
                this.hexdump.print("dreturn");
                return 1;
            }
            case 176: {
                this.hexdump.print("areturn");
                return 1;
            }
            case 177: {
                this.hexdump.print("return");
                return 1;
            }
            case 178: {
                int idx = dis.readUnsignedShort();
                this.hexdump.print("getstatic " + this.show(idx));
                return 3;
            }
            case 179: {
                int idx = dis.readUnsignedShort();
                this.hexdump.print("putstatic " + this.show(idx));
                return 3;
            }
            case 180: {
                int idx = dis.readUnsignedShort();
                this.hexdump.print("getfield " + this.show(idx));
                return 3;
            }
            case 181: {
                int idx = dis.readUnsignedShort();
                this.hexdump.print("putfield " + this.show(idx));
                return 3;
            }
            case 182: {
                int idx = dis.readUnsignedShort();
                CPInfo info = this.pool.get(idx);
                this.hexdump.print("invokevirtual " + this.show(info));
                return 3;
            }
            case 183: {
                int idx = dis.readUnsignedShort();
                CPInfo info = this.pool.get(idx);
                this.hexdump.print("invokespecial " + this.show(info));
                return 3;
            }
            case 184: {
                int idx = dis.readUnsignedShort();
                CPInfo info = this.pool.get(idx);
                this.hexdump.print("invokestatic " + this.show(info));
                return 3;
            }
            case 185: {
                int idx = dis.readUnsignedShort();
                CPInfo info = this.pool.get(idx);
                int count = dis.readUnsignedByte();
                dis.readUnsignedByte();
                this.hexdump.print("invokeinterface " + this.show(info) + ", " + count);
                return 5;
            }
            case 186: {
                int idx = dis.readUnsignedShort();
                CPInfo.InvokeDynamicInfo info = (CPInfo.InvokeDynamicInfo)this.pool.get(idx);
                dis.readUnsignedByte();
                dis.readUnsignedByte();
                this.hexdump.print("invokedynamic " + this.show(info));
                return 5;
            }
            case 187: {
                int idx = dis.readUnsignedShort();
                CPInfo info = this.pool.get(idx);
                this.hexdump.print("new " + this.show(info));
                return 3;
            }
            case 188: {
                int atype = dis.readUnsignedByte();
                this.hexdump.print("newarray " + atype);
                return 2;
            }
            case 189: {
                int idx = dis.readUnsignedShort();
                CPInfo info = this.pool.get(idx);
                this.hexdump.print("anewarray " + this.show(info));
                return 3;
            }
            case 190: {
                this.hexdump.print("arraylength");
                return 1;
            }
            case 191: {
                this.hexdump.print("athrow");
                return 1;
            }
            case 192: {
                int idx = dis.readUnsignedShort();
                CPInfo info = this.pool.get(idx);
                this.hexdump.print("checkcast " + this.show(info));
                return 3;
            }
            case 193: {
                int idx = dis.readUnsignedShort();
                CPInfo info = this.pool.get(idx);
                this.hexdump.print("instanceof " + this.show(info));
                return 3;
            }
            case 194: {
                this.hexdump.print("monitorenter");
                return 1;
            }
            case 195: {
                this.hexdump.print("monitorexit");
                return 1;
            }
            case 198: {
                short jumpTo = dis.readShort();
                this.hexdump.print("ifnull " + StringUtil.hex(offset + jumpTo, 4));
                return 3;
            }
            case 199: {
                short jumpTo = dis.readShort();
                this.hexdump.print("ifnonnull " + StringUtil.hex(offset + jumpTo, 4));
                return 3;
            }
        }
        throw new UtilException("Invalid opcode \\x" + StringUtil.hex(opcode, 2));
    }

    public static class HexDumpStream
    extends InputStream {
        private final InputStream fis;
        private int pos = 0;
        private int cnt = 0;
        private int wrap = 16;
        private byte[] str;
        private final PrintWriter out;
        private final StringBuilder tmp = new StringBuilder();
        private final boolean cleanMode;

        public HexDumpStream(boolean cleanMode, PrintWriter out, InputStream fis) {
            this.cleanMode = cleanMode;
            this.fis = fis;
            this.str = new byte[this.wrap];
            this.out = out == null ? new PrintWriter(System.out) : out;
        }

        @Override
        public int read() throws IOException {
            int b = this.fis.read();
            if (b == -1) {
                return -1;
            }
            if (this.cnt >= this.wrap) {
                if (!this.cleanMode) {
                    this.out.println(new String(this.str));
                }
                this.cnt = 0;
            }
            if (this.cnt == 0 && !this.cleanMode) {
                this.out.print(StringUtil.hex(this.pos, 8) + " ");
            }
            this.str[this.cnt] = b > 32 && b < 127 ? (int)b : 46;
            if (!this.cleanMode) {
                this.out.print(StringUtil.hex(b, 2) + " ");
            }
            this.out.flush();
            ++this.cnt;
            ++this.pos;
            return b;
        }

        public void append(String s) {
            this.tmp.append(s);
        }

        public void print(Object obj) {
            if (!this.cleanMode) {
                if (this.cnt == 0) {
                    this.out.print("         ");
                }
                for (int i = this.cnt; i < this.wrap; ++i) {
                    this.out.print("   ");
                    this.str[i] = 32;
                }
                this.out.print(new String(this.str) + "  ");
            }
            this.out.print(this.tmp);
            this.tmp.delete(0, this.tmp.length());
            this.out.println(obj);
            this.out.flush();
            this.cnt = 0;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.out.flush();
        }
    }
}

