/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.AnnotationHolder;
import org.zinutils.bytecode.AnnotationType;
import org.zinutils.bytecode.AttributeInfo;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.bytecode.ClassPoolEntry;
import org.zinutils.bytecode.ConstPool;
import org.zinutils.bytecode.EnclosingMethod;
import org.zinutils.bytecode.FieldInfo;
import org.zinutils.bytecode.InnerClass;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.bytecode.JavaRuntimeReplica;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.MethodInfo;
import org.zinutils.bytecode.RuntimeVisibleAnnotations;
import org.zinutils.collections.ListMap;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;

public class ByteCodeFile
implements AnnotationHolder {
    public static final int javaMagic = -889275714;
    public static final short javaMajorVersion = 50;
    public static final short javaMinorVersion = 0;
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SUPER = 32;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_BRIDGE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_STRICT = 2048;
    public static final short ACC_ACCESSMETH = 4096;
    public static final short ACC_ENUM = 16384;
    public static final byte CONSTANT_UTF8 = 1;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_Interfaceref = 11;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_MethodHandle = 15;
    public static final byte CONSTANT_MethodType = 16;
    public static final byte CONSTANT_InvokeDynamic = 18;
    protected ConstPool pool;
    protected List<Integer> interfaces = new ArrayList<Integer>();
    private int access_flags = -1;
    private int this_idx = -1;
    private int super_idx = -1;
    private List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private List<MethodInfo> methods = new ArrayList<MethodInfo>();
    List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
    private final String qualifiedName;
    private ListMap<AnnotationType, Annotation> annotations = new ListMap();
    final TreeSet<InnerClass> innerClasses = new TreeSet();
    EnclosingMethod enclosingMethod;
    private boolean completed = false;
    private int minorVers = 0;
    protected int majorVers = 50;

    protected ByteCodeFile() {
        this((String)null);
    }

    protected ByteCodeFile(String qualifiedName) {
        this.qualifiedName = qualifiedName;
        this.pool = new ConstPool();
    }

    public ByteCodeFile(File from, String qualifiedName) {
        this.qualifiedName = qualifiedName;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(from);
            this.read(fis);
            fis.close();
        }
        catch (IOException ex) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw UtilException.wrap(ex);
        }
    }

    public ByteCodeFile(InputStream fis) {
        this.read(fis);
        this.qualifiedName = null;
    }

    public void setVersion(int maj, int min) {
        this.majorVers = maj;
        this.minorVers = min;
    }

    private void read(InputStream fis) {
        try {
            DataInputStream dis = new DataInputStream(fis);
            int magic = dis.readInt();
            if (magic != -889275714) {
                throw new UtilException("This is not a bytecode file");
            }
            this.minorVers = dis.readUnsignedShort();
            this.majorVers = dis.readUnsignedShort();
            this.readConstantPool(dis);
            this.access_flags = dis.readUnsignedShort();
            this.this_idx = dis.readUnsignedShort();
            this.super_idx = dis.readUnsignedShort();
            this.readInterfaces(dis);
            this.readFields(dis);
            this.readMethods(dis);
            this.readAttributes(dis, this.attributes, this);
            if (dis.available() != 0) {
                throw new UtilException("There are still " + dis.available() + " bytes available on the stream");
            }
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void makeInterface() {
        this.access_flags = 1537;
    }

    public void makeAbstract() {
        this.access_flags = 1025;
    }

    public String getName() {
        return ((CPInfo.ClassInfo)this.pool.get(this.this_idx)).justName();
    }

    public String getSuperClass() {
        if (this.super_idx == 0) {
            return null;
        }
        return ((CPInfo.ClassInfo)this.pool.get(this.super_idx)).justName();
    }

    public CPInfo.RefInfo getRefInfoIfValidIdx(int idx) {
        if (idx < 1 || idx >= this.pool.size()) {
            return null;
        }
        CPInfo ret = this.pool.get(idx);
        if (ret instanceof CPInfo.RefInfo) {
            return (CPInfo.RefInfo)ret;
        }
        return null;
    }

    public String getString(int idx) {
        if (idx < 1 || idx >= this.pool.size()) {
            return null;
        }
        CPInfo ret = this.pool.get(idx);
        if (ret instanceof CPInfo.StringInfo) {
            return ((CPInfo.StringInfo)ret).asString();
        }
        return null;
    }

    public boolean isConcrete() {
        return (this.access_flags & 0x600) == 0;
    }

    public void write(DataOutputStream dos) throws IOException {
        if (!this.completed) {
            if (this.access_flags == -1) {
                this.access_flags = 33;
            }
            if (this.this_idx == -1) {
                throw new UtilException("You must specify a this class");
            }
            if (this.super_idx == -1) {
                this.super_idx = this.pool.requireClass("java/lang/Object");
            }
            for (FieldInfo fi : this.fields) {
                fi.complete();
            }
            for (MethodInfo mi : this.methods) {
                if (!(mi instanceof MethodDefiner)) continue;
                ((MethodDefiner)((Object)mi)).complete();
            }
            this.complete();
        }
        dos.writeInt(-889275714);
        dos.writeShort(this.minorVers);
        dos.writeShort(this.majorVers);
        this.pool.writeConstantPool(dos);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.this_idx);
        dos.writeShort(this.super_idx);
        this.writeInterfaces(dos);
        this.writeFields(dos);
        this.writeMethods(dos);
        this.writeAttributes(dos, this.attributes);
    }

    private void complete() throws IOException {
        DataOutputStream dos;
        for (int i = 0; i < this.methods.size(); ++i) {
            MethodInfo first = this.methods.get(i);
            if ((first.access_flags & 0x400) != 0) {
                this.access_flags |= 0x400;
            }
            for (int j = i + 1; j < this.methods.size(); ++j) {
                MethodInfo second = this.methods.get(j);
                if (!first.getName().equals(second.getName()) || !first.getSignature().equals(second.getSignature())) continue;
                throw new UtilException("Duplicate method: " + first.getName() + first.getSignature() + " in class " + this.getName());
            }
        }
        if (!this.innerClasses.isEmpty()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            dos.writeShort(this.innerClasses.size());
            for (InnerClass i : this.innerClasses) {
                i.write(dos);
            }
            this.attributes.add(new AttributeInfo(this, "InnerClasses", baos.toByteArray()));
        }
        if (this.enclosingMethod != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            this.enclosingMethod.write(dos);
            this.attributes.add(new AttributeInfo(this, "EnclosingMethod", baos.toByteArray()));
        }
        for (AnnotationType at : this.annotations) {
            at.addTo(this, this.attributes, this.annotations.get(at), -1);
        }
        this.completed = true;
    }

    private void readConstantPool(DataInputStream dis) throws IOException {
        int poolCount = dis.readUnsignedShort();
        this.pool = new ConstPool(poolCount);
        for (int idx = 1; idx < poolCount; ++idx) {
            CPInfo entry = this.readPoolEntry(dis);
            this.pool.setPoolEntry(idx, entry);
            if (!(entry instanceof CPInfo.DoubleEntry)) continue;
            ++idx;
        }
    }

    private void readInterfaces(DataInputStream dis) throws IOException {
        int cnt = dis.readUnsignedShort();
        for (int i = 0; i < cnt; ++i) {
            this.interfaces.add(dis.readUnsignedShort());
        }
    }

    private void writeInterfaces(DataOutputStream dos) throws IOException {
        dos.writeShort(this.interfaces.size());
        for (int ci : this.interfaces) {
            dos.writeShort(ci);
        }
    }

    private void readFields(DataInputStream dis) throws IOException {
        int cnt = dis.readUnsignedShort();
        for (int i = 0; i < cnt; ++i) {
            int access = dis.readUnsignedShort();
            int name = dis.readUnsignedShort();
            int descriptor = dis.readUnsignedShort();
            FieldInfo fi = new FieldInfo(this, access, name, descriptor);
            this.readAttributes(dis, fi.attributes, fi);
            this.fields.add(fi);
        }
    }

    private void writeFields(DataOutputStream dos) throws IOException {
        dos.writeShort(this.fields.size());
        for (FieldInfo fi : this.fields) {
            fi.write(dos);
        }
    }

    private void readMethods(DataInputStream dis) throws IOException {
        int cnt = dis.readUnsignedShort();
        for (int i = 0; i < cnt; ++i) {
            MethodInfo mi = new MethodInfo(this);
            mi.access_flags = (short)dis.readUnsignedShort();
            mi.nameIdx = (short)dis.readUnsignedShort();
            mi.descriptorIdx = (short)dis.readUnsignedShort();
            this.readAttributes(dis, mi.attributes, mi);
            this.methods.add(mi);
        }
    }

    private void writeMethods(DataOutputStream dos) throws IOException {
        dos.writeShort(this.methods.size());
        for (MethodInfo mi : this.methods) {
            mi.write(dos);
        }
    }

    private void readAttributes(DataInputStream dis, List<AttributeInfo> attrs, AnnotationHolder holder) throws IOException {
        int cnt = dis.readUnsignedShort();
        for (int i = 0; i < cnt; ++i) {
            int idx = dis.readUnsignedShort();
            int len = dis.readInt();
            byte[] bytes = new byte[len];
            this.readBytes(dis, bytes);
            AttributeInfo attr = new AttributeInfo(this.pool, idx, bytes);
            attrs.add(attr);
            if (attr.hasName("RuntimeVisibleAnnotations")) {
                for (Annotation ann : Annotation.parse(this, attr)) {
                    holder.addAnnotation(AnnotationType.RuntimeVisibleAnnotations, ann);
                }
                continue;
            }
            if (!attr.hasName("RuntimeInvisibleAnnotations")) continue;
            for (Annotation ann : Annotation.parse(this, attr)) {
                holder.addAnnotation(AnnotationType.RuntimeInvisibleAnnotations, ann);
            }
        }
    }

    void writeAttributes(DataOutputStream dos, List<AttributeInfo> attrs) throws IOException {
        dos.writeShort(attrs.size());
        for (AttributeInfo ai : attrs) {
            dos.writeShort(ai.nameIdx);
            dos.writeInt(ai.getBytes().length);
            dos.write(ai.getBytes());
        }
    }

    protected CPInfo readPoolEntry(DataInputStream dis) throws IOException {
        int tag = dis.readUnsignedByte();
        switch (tag) {
            case 1: {
                return this.readUtf8Entry(dis);
            }
            case 3: {
                return this.readIntegerEntry(dis);
            }
            case 4: {
                return this.readFloatEntry(dis);
            }
            case 5: {
                return this.readLongEntry(dis);
            }
            case 6: {
                return this.readDoubleEntry(dis);
            }
            case 7: {
                return this.readClassEntry(dis);
            }
            case 8: {
                return this.readStringEntry(dis);
            }
            case 9: 
            case 10: 
            case 11: {
                return this.readRefEntry(dis, tag);
            }
            case 12: {
                return this.readNameAndType(dis);
            }
            case 15: {
                return this.readMethodHandle(dis);
            }
            case 16: {
                return this.readMethodType(dis);
            }
            case 18: {
                return this.readInvokeDynamic(dis);
            }
        }
        throw new UtilException("There is no handler for tag " + tag);
    }

    private CPInfo.Utf8Info readUtf8Entry(DataInputStream dis) throws IOException {
        int len = dis.readUnsignedShort();
        byte[] bytes = new byte[len];
        this.readBytes(dis, bytes);
        return new CPInfo.Utf8Info(bytes);
    }

    private CPInfo.IntegerInfo readIntegerEntry(DataInputStream dis) throws IOException {
        return new CPInfo.IntegerInfo(dis.readInt());
    }

    private CPInfo.FloatInfo readFloatEntry(DataInputStream dis) throws IOException {
        return new CPInfo.FloatInfo(dis.readFloat());
    }

    private CPInfo.LongInfo readLongEntry(DataInputStream dis) throws IOException {
        int high = dis.readInt();
        int low = dis.readInt();
        return new CPInfo.LongInfo(high, low);
    }

    private CPInfo.DoubleInfo readDoubleEntry(DataInputStream dis) throws IOException {
        double val = dis.readDouble();
        return new CPInfo.DoubleInfo(val);
    }

    private CPInfo.ClassInfo readClassEntry(DataInputStream dis) throws IOException {
        int idx = dis.readUnsignedShort();
        return new CPInfo.ClassInfo(this.pool, idx);
    }

    private CPInfo.StringInfo readStringEntry(DataInputStream dis) throws IOException {
        int idx = dis.readUnsignedShort();
        return new CPInfo.StringInfo(this.pool, idx);
    }

    private CPInfo.RefInfo readRefEntry(DataInputStream dis, int tag) throws IOException {
        int clz = dis.readUnsignedShort();
        int nt = dis.readUnsignedShort();
        return new CPInfo.RefInfo(this.pool, clz, nt, tag);
    }

    private CPInfo.NTInfo readNameAndType(DataInputStream dis) throws IOException {
        int name = dis.readUnsignedShort();
        int descriptor = dis.readUnsignedShort();
        return new CPInfo.NTInfo(this.pool, name, descriptor);
    }

    protected CPInfo.MHInfo readMethodHandle(DataInputStream dis) throws IOException {
        int kind = dis.readUnsignedByte();
        int ridx = dis.readUnsignedShort();
        return new CPInfo.MHInfo(this.pool, kind, ridx);
    }

    protected CPInfo.MTInfo readMethodType(DataInputStream dis) throws IOException {
        int didx = dis.readUnsignedShort();
        return new CPInfo.MTInfo(this.pool, didx);
    }

    protected CPInfo.InvokeDynamicInfo readInvokeDynamic(DataInputStream dis) throws IOException {
        int bootstrapMethod = dis.readUnsignedShort();
        int ntidx = dis.readUnsignedShort();
        return new CPInfo.InvokeDynamicInfo(this.pool, bootstrapMethod, ntidx);
    }

    public void addInterface(String intf) {
        int idx = this.pool.requireClass(intf);
        this.interfaces.add(idx);
    }

    public boolean extendsClass(String clzName) {
        String name = FileUtils.convertDottedToSlashPath(clzName);
        return name.equals(((CPInfo.ClassInfo)this.pool.get(this.super_idx)).justName());
    }

    public boolean nestedExtendsClass(JavaRuntimeReplica jrr, String clzName) {
        try {
            if (this.extendsClass(clzName)) {
                return true;
            }
            String parentName = FileUtils.convertToDottedName(new File(((CPInfo.ClassInfo)this.pool.get(this.super_idx)).justName()));
            if (parentName.equals("java.lang.Object")) {
                return false;
            }
            return jrr.getClass(parentName).nestedExtendsClass(jrr, clzName);
        }
        catch (UtilException ex) {
            System.out.println("Error: " + ex.getMessage());
            if (ex.getMessage().startsWith("JRR cannot")) {
                return false;
            }
            throw ex;
        }
    }

    public boolean implementsInterface(Class<?> class1) {
        String name = FileUtils.convertDottedToSlashPath(class1.getCanonicalName());
        for (int idx : this.interfaces) {
            CPInfo.ClassInfo c = (CPInfo.ClassInfo)this.pool.get(idx);
            if (!c.asClean().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<String> interfacesImplemented() {
        ArrayList<String> ret = new ArrayList<String>();
        for (int idx : this.interfaces) {
            CPInfo.ClassInfo c = (CPInfo.ClassInfo)this.pool.get(idx);
            ret.add(c.asClean());
        }
        return ret;
    }

    protected void readBytes(DataInputStream dis, byte[] bytes) throws IOException {
        int cnt;
        for (int off = 0; off < bytes.length; off += cnt) {
            cnt = dis.read(bytes, off, bytes.length - off);
        }
    }

    public void thisClass(String name) {
        if (this.this_idx != -1) {
            throw new UtilException("Cannot define 'this' class twice");
        }
        this.this_idx = this.pool.requireClass(name);
    }

    public void superClass(String name) {
        if (this.super_idx != -1) {
            throw new UtilException("Cannot define 'super' class twice");
        }
        this.super_idx = this.pool.requireClass(name);
    }

    public void addField(FieldInfo field) {
        this.fields.add(field);
    }

    public void addMethod(MethodCreator ret) {
        if (this.methods.contains(ret)) {
            throw new UtilException("Cannot add the same method twice");
        }
        this.methods.add(ret);
    }

    public String toString() {
        if (this.qualifiedName != null) {
            return "BCF[" + this.qualifiedName + "]";
        }
        if (this.getName() != null) {
            return "BCF[" + this.getName() + "]";
        }
        return super.toString();
    }

    public Iterable<FieldInfo> allFields() {
        return this.fields;
    }

    public Iterable<MethodInfo> allMethods() {
        return this.methods;
    }

    public boolean hasMethodsWithAnnotation(String string) {
        String mapped = JavaInfo.map(string);
        for (MethodInfo mi : this.methods) {
            for (AttributeInfo ai : mi.attributes) {
                RuntimeVisibleAnnotations rva;
                if (!ai.hasName("RuntimeVisibleAnnotations") || !(rva = new RuntimeVisibleAnnotations(this, ai)).has(mapped)) continue;
                return true;
            }
        }
        return false;
    }

    public AttributeInfo newAttribute(String named, byte[] data) {
        return new AttributeInfo(this.pool, this.pool.requireUtf8(named), data);
    }

    @Override
    public Annotation addAnnotation(AnnotationType type, Annotation annotation) {
        this.annotations.add(type, annotation);
        return annotation;
    }

    public boolean hasClassAnnotation(String ann) {
        for (AnnotationType i : this.annotations) {
            for (Annotation j : this.annotations.get(i)) {
                if (!j.name.equals(ann)) continue;
                return true;
            }
        }
        return false;
    }

    public Annotation getClassAnnotation(String ann) {
        for (AnnotationType i : this.annotations) {
            for (Annotation j : this.annotations.get(i)) {
                if (!j.name.equals(ann)) continue;
                return j;
            }
        }
        return null;
    }

    public void destroy() {
    }

    public Iterable<ClassPoolEntry> getClassNames() {
        ArrayList<ClassPoolEntry> ret = new ArrayList<ClassPoolEntry>();
        for (Map.Entry<Integer, CPInfo.ClassInfo> i : this.pool.entries(CPInfo.ClassInfo.class)) {
            ret.add(new ClassPoolEntry(i.getValue()));
        }
        return ret;
    }

    public Iterable<ClassPoolEntry> getSignatures() {
        ArrayList<ClassPoolEntry> ret = new ArrayList<ClassPoolEntry>();
        for (Map.Entry<Integer, CPInfo.NTInfo> i : this.pool.entries(CPInfo.NTInfo.class)) {
            ret.add(new ClassPoolEntry(i.getValue()));
        }
        return ret;
    }

    public <T extends CPInfo> Iterable<Map.Entry<Integer, T>> poolEntries(Class<T> clz) {
        if (clz == null) {
            clz = CPInfo.class;
        }
        return this.pool.entries(clz);
    }

    public int methodCount() {
        return this.methods.size();
    }
}

