/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import org.zinutils.bytecode.BCEClassLoader;
import org.zinutils.bytecode.ByteCodeCreator;
import org.zinutils.bytecode.ByteCodeInspector;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.bytecode.ByteCodeStorage;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.UtilException;

public class ByteCodeEnvironment
implements ByteCodeStorage {
    private final Map<String, ByteCodeCreator> classes = new TreeMap<String, ByteCodeCreator>();
    private BCEClassLoader loader;

    @Override
    public ByteCodeCreator newClass(String name) {
        if (this.classes.containsKey(name)) {
            throw new InvalidUsageException("cannot define class " + name + " twice");
        }
        return new ByteCodeCreator(this, name);
    }

    @Override
    public ByteCodeSink getOrCreate(String name) {
        if (this.classes.containsKey(name)) {
            return this.classes.get(name);
        }
        return new ByteCodeCreator(this, name);
    }

    public void associate(ByteCodeCreator byteCodeCreator) {
        this.classes.put(byteCodeCreator.getCreatedName(), byteCodeCreator);
    }

    public int size() {
        return this.classes.size();
    }

    @Override
    public boolean hasClass(String name) {
        return this.classes.containsKey(name);
    }

    public boolean generatesClass(String name) {
        return this.classes.containsKey(name) && this.classes.get(name).generatesCode();
    }

    @Override
    public ByteCodeCreator get(String name) {
        if (!this.classes.containsKey(name)) {
            System.out.println(this.classes.keySet());
            throw new UtilException("There is no class " + name);
        }
        return this.classes.get(name);
    }

    public Iterable<ByteCodeCreator> all() {
        return this.classes.values();
    }

    public BCEClassLoader getClassLoader() {
        if (this.loader == null) {
            this.loader = new BCEClassLoader(this);
        }
        return this.loader;
    }

    public void dumpAll(boolean cleanMode) {
        ByteCodeInspector bci = new ByteCodeInspector(cleanMode);
        for (ByteCodeCreator bcc : this.classes.values()) {
            bci.read(new PrintWriter(System.out), new ByteArrayInputStream(bcc.generate()));
        }
    }

    public String toString() {
        return this.classes.keySet().toString();
    }
}

