/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.AnnotationType;
import org.zinutils.bytecode.AttributeInfo;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.bytecode.EnclosingMethod;
import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.FieldExpr;
import org.zinutils.bytecode.FieldInfo;
import org.zinutils.bytecode.FieldObject;
import org.zinutils.bytecode.GenericAnnotator;
import org.zinutils.bytecode.InnerClass;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.MethodInfo;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.SourceCodeCreator;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;

public class ByteCodeCreator
implements ByteCodeSink {
    private ByteCodeFile bcf;
    private final File file;
    private String superclass;
    private final String qualifiedName;
    private final Map<String, FieldObject> fields = new HashMap<String, FieldObject>();
    private final ByteCodeEnvironment env;
    private SourceCodeCreator scc;
    private boolean generateCode = true;

    public ByteCodeCreator(ByteCodeEnvironment env, String qualifiedName) {
        this.qualifiedName = qualifiedName;
        this.bcf = new ByteCodeFile(qualifiedName);
        File tmp = FileUtils.convertDottedToPath(qualifiedName);
        this.file = new File(tmp.getParentFile(), tmp.getName() + ".class");
        this.bcf.thisClass(FileUtils.convertToDottedNameDroppingExtension(this.file));
        this.env = env;
        env.associate(this);
    }

    @Override
    public void version(int vno) {
        this.bcf.majorVers = vno;
    }

    public int methodCount() {
        return this.bcf.methodCount();
    }

    public Iterable<MethodInfo> allMethods() {
        return this.bcf.allMethods();
    }

    @Override
    public void generateAssociatedSourceFile() {
        this.generateSourceFile(this.qualifiedName.substring(this.qualifiedName.lastIndexOf(".") + 1) + ".java");
    }

    public void generateSourceFile(String sfile) {
        if (this.scc == null) {
            this.scc = new SourceCodeCreator(sfile);
            short sfid = this.bcf.pool.requireUtf8(sfile);
            this.addAttribute("SourceFile", new byte[]{(byte)(sfid >> 8 & 0xFF), (byte)(sfid & 0xFF)});
        }
    }

    @Override
    public String getCreatedName() {
        return this.qualifiedName;
    }

    @Override
    public void superclass(String string) {
        this.superclass = string;
        this.bcf.superClass(string);
        if (this.scc != null) {
            this.scc.superclass(string);
        }
    }

    public void addToJar(JarOutputStream jos) {
        if (!this.generateCode) {
            return;
        }
        try {
            JarEntry je = new JarEntry(this.file.getPath().replaceAll("\\\\", "/"));
            jos.putNextEntry(je);
            this.generateByteCodes(jos);
            if (this.scc != null) {
                je = new JarEntry(this.file.getPath().replaceAll("\\\\", "/").replaceFirst("\\.class$", ".java"));
                jos.putNextEntry(je);
                this.scc.writeTo(jos);
            }
        }
        catch (Exception e) {
            throw UtilException.wrap(e);
        }
    }

    public void writeTo(File wto) {
        if (!this.generateCode) {
            return;
        }
        FileOutputStream fos = null;
        FileUtils.assertDirectory(wto.getParentFile());
        try {
            fos = new FileOutputStream(wto);
            this.generateByteCodes(fos);
            fos.close();
            fos = null;
            if (this.scc != null) {
                String scf = this.scc.getName();
                fos = new FileOutputStream(new File(wto.getParentFile(), scf));
                this.scc.writeTo(fos);
                fos.close();
                fos = null;
            }
        }
        catch (Exception e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw UtilException.wrap(e);
        }
    }

    @Override
    public byte[] generate() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.generateByteCodes(baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw UtilException.wrap(e);
        }
    }

    private void generateByteCodes(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        this.bcf.write(dos);
        dos.flush();
    }

    @Override
    public MethodDefiner createMethod(boolean isStatic, String returns, String name) {
        if (name.contains(".")) {
            throw new UtilException("Cannot create method name: " + name);
        }
        MethodCreator ret = new MethodCreator(this, this.bcf, isStatic, returns, name);
        this.bcf.addMethod(ret);
        if (this.scc != null) {
            ret.generateSource(this.scc.newMethod(ret));
        }
        return ret;
    }

    @Override
    public String getSuperClass() {
        return this.superclass;
    }

    public String toString() {
        return "Creating " + this.qualifiedName;
    }

    @Override
    public FieldInfo defineField(boolean isFinal, JavaInfo.Access access, String type, String name) {
        return this.defineField(isFinal, access, new JavaType(type), name);
    }

    @Override
    public FieldInfo defineField(boolean isFinal, JavaInfo.Access access, JavaType type, String name) {
        this.fields.put(name, new FieldObject(access.isStatic(), this.getCreatedName(), type, name));
        FieldInfo field = new FieldInfo(this.bcf, isFinal, access, type.getActual(), name);
        this.bcf.addField(field);
        GenericAnnotator.annotateField(field, type);
        if (this.scc != null) {
            this.scc.addField(field);
        }
        return field;
    }

    @Override
    public void inheritsField(boolean isFinal, JavaInfo.Access access, JavaType type, String name) {
        this.fields.put(name, new FieldObject(access.isStatic(), this.getCreatedName(), type, name));
    }

    @Override
    public void inheritsField(boolean isFinal, JavaInfo.Access access, String type, String name) {
        this.fields.put(name, new FieldObject(access.isStatic(), this.getCreatedName(), new JavaType(type), name));
    }

    @Override
    public void inheritsClass(String clz) {
        ByteCodeCreator byteCodeCreator = this.env.get(clz);
        if (byteCodeCreator == null) {
            throw new UtilException("There is no class " + clz + " to inherit from");
        }
        for (Map.Entry<String, FieldObject> fo : byteCodeCreator.fields.entrySet()) {
            this.fields.put(fo.getKey(), fo.getValue().rewriteFor(this.qualifiedName));
        }
    }

    @Override
    public FieldExpr getField(NewMethodDefiner meth, String name) {
        if (!this.fields.containsKey(name)) {
            throw new UtilException("There is no field " + name + " in " + this.getCreatedName());
        }
        return this.fields.get(name).use(meth);
    }

    @Override
    public FieldExpr getField(NewMethodDefiner meth, Expr obj, String name) {
        ByteCodeCreator creatorFor = this.env.get(obj.getType());
        if (creatorFor == null) {
            throw new UtilException("The class " + obj.getType() + " is not registered in the system");
        }
        if (!creatorFor.fields.containsKey(name)) {
            throw new UtilException("There is no field " + name + " in " + creatorFor.qualifiedName);
        }
        return creatorFor.fields.get(name).useOn(meth, obj);
    }

    @Override
    public void makeAbstract() {
        this.bcf.makeAbstract();
    }

    @Override
    public void makeInterface() {
        this.bcf.makeInterface();
    }

    @Override
    public void implementsInterface(String intf) {
        this.bcf.addInterface(intf);
        if (this.scc != null) {
            this.scc.implementsInterface(intf);
        }
    }

    @Override
    public void signatureAttribute(String name, String sig) {
        short u8 = this.bcf.pool.requireUtf8(sig);
        byte[] data = new byte[]{(byte)(u8 >> 8 & 0xFF), (byte)(u8 & 0xFF)};
        this.addAttribute(name, data);
    }

    @Override
    public void addAttribute(String name, byte[] data) {
        AttributeInfo attr = this.bcf.newAttribute(name, data);
        this.bcf.attributes.add(attr);
    }

    @Override
    public Annotation addRTVAnnotation(String attrClass) {
        return this.bcf.addAnnotation(AnnotationType.RuntimeVisibleAnnotations, new Annotation(this.bcf, attrClass));
    }

    @Override
    public Annotation newAnnotation(String attrClass) {
        return new Annotation(this.bcf, attrClass);
    }

    @Override
    public void addInnerClassReference(JavaInfo.Access access, String parentClass, String inner) {
        this.bcf.innerClasses.add(new InnerClass(this.bcf, access, parentClass + "$" + inner, parentClass, inner));
    }

    @Override
    public void addClassReference(JavaInfo.Access access, String fullInner, String enclosing, String inner) {
        this.bcf.innerClasses.add(new InnerClass(this.bcf, access, fullInner, enclosing, inner));
    }

    @Override
    public void enclosingMethod(String clazz, NewMethodDefiner method) {
        this.bcf.enclosingMethod = new EnclosingMethod(this.bcf, clazz, method);
    }

    public ByteCodeCreator dontGenerate() {
        this.generateCode = false;
        return this;
    }

    public boolean generatesCode() {
        return this.generateCode;
    }
}

