/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.FieldInfo;
import org.zinutils.bytecode.MethodInfo;
import org.zinutils.exceptions.UtilException;

public class ByteCodeAPI {
    public static void main(String[] argv) {
        try {
            ArrayList<String> args = new ArrayList<String>();
            for (String s : argv) {
                if (s.startsWith("-")) {
                    throw new UtilException("Unknown argument: " + s);
                }
                args.add(s);
            }
            if (args.size() < 1) {
                System.out.println("Usage: inspector <class> ...");
                return;
            }
            for (String s : args) {
                InputStream fis = ByteCodeAPI.class.getResourceAsStream(s);
                if (fis == null) {
                    throw new RuntimeException("Could not find " + s);
                }
                ByteCodeFile bcf = new ByteCodeFile(fis);
                fis.close();
                System.out.print(ByteCodeAPI.format(bcf));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.out);
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            System.exit(2);
        }
    }

    public void process(Writer writer, List<String> args) throws IOException {
        TreeSet<String> set = new TreeSet<String>(args);
        for (String s : set) {
            FileInputStream fis = new FileInputStream(s);
            ByteCodeFile bcf = new ByteCodeFile(fis);
            ((InputStream)fis).close();
            writer.append(ByteCodeAPI.format(bcf));
        }
        writer.flush();
    }

    private static String format(ByteCodeFile bcf) {
        StringBuilder sb = new StringBuilder();
        sb.append("class ");
        sb.append(bcf.getName());
        sb.append("\r\n");
        sb.append("  extends ");
        sb.append(bcf.getSuperClass());
        sb.append("\r\n");
        TreeSet<String> interfaces = new TreeSet<String>();
        interfaces.addAll(bcf.interfacesImplemented());
        for (String string : interfaces) {
            sb.append("  implements ");
            sb.append(string);
            sb.append("\r\n");
        }
        TreeSet<String> fields = new TreeSet<String>();
        for (FieldInfo f : bcf.allFields()) {
            fields.add(ByteCodeAPI.format(f));
        }
        for (String s : fields) {
            sb.append(s);
            sb.append("\r\n");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (MethodInfo m : bcf.allMethods()) {
            treeSet.add(ByteCodeAPI.format(m));
        }
        for (String s : treeSet) {
            sb.append(s);
            sb.append("\r\n");
        }
        return sb.toString();
    }

    private static String format(FieldInfo f) {
        StringBuilder sb = new StringBuilder();
        sb.append("    F ");
        sb.append(f.getName());
        sb.append(" ");
        sb.append(f.getSignature());
        sb.append(" ");
        sb.append(f.getAccess());
        return sb.toString();
    }

    private static String format(MethodInfo m) {
        StringBuilder sb = new StringBuilder();
        sb.append("    M ");
        sb.append(m.getName());
        sb.append(" ");
        sb.append(m.getSignature());
        sb.append(" ");
        sb.append(m.getAccess());
        return sb.toString();
    }
}

