/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.utils.Justification;

public class BoxExpr
extends Expr {
    private final IExpr expr;
    private final String outType;
    private final String inType;

    public BoxExpr(MethodCreator meth, IExpr expr) {
        super(meth);
        this.expr = expr;
        this.outType = expr.getType().equals("boolean") ? "java.lang.Boolean" : (expr.getType().equals("double") ? "java.lang.Double" : (expr.getType().equals("int") ? "java.lang.Integer" : (expr.getType().equals("long") ? "java.lang.Long" : null)));
        this.inType = this.outType != null ? expr.getType() : null;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        this.expr.spitOutByteCode(meth);
        if (this.expr.getType().equals(this.inType)) {
            meth.invokeStatic(this.outType, this.outType, "valueOf", this.inType);
        }
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        if (!suppressFirst) {
            sb.append(Justification.LEFT.format("", ind));
        }
        sb.append("autobox[");
        int currline = lnt.current();
        this.expr.asSource(sb, lnt, ind, true);
        if (lnt.current() > currline) {
            sb.append(Justification.LEFT.format("", ind));
        }
        sb.append("]");
        if (!suppressFirst) {
            lnt.advance(1);
        }
    }

    @Override
    public String getType() {
        return this.outType != null ? this.outType : this.expr.getType();
    }
}

