/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.IfExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.PCExpr;
import org.zinutils.utils.Justification;

public class BlockExpr
extends Expr {
    private final IExpr[] exprs;
    private final List<PCExpr> pcexprs = new ArrayList<PCExpr>();

    public BlockExpr(NewMethodDefiner meth, IExpr[] exprs) {
        super(meth);
        ArrayList<IExpr> filtered = new ArrayList<IExpr>();
        for (IExpr e : exprs) {
            if (e == null) continue;
            filtered.add(e);
        }
        this.exprs = filtered.toArray(new IExpr[filtered.size()]);
    }

    public BlockExpr(NewMethodDefiner meth, List<IExpr> exprs) {
        super(meth);
        ArrayList<IExpr> filtered = new ArrayList<IExpr>();
        for (IExpr e : exprs) {
            if (e == null) continue;
            filtered.add(e);
        }
        this.exprs = filtered.toArray(new IExpr[filtered.size()]);
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        for (IExpr e : this.exprs) {
            int pc = meth.currentPC();
            e.spitOutByteCode(meth);
            int toPC = meth.currentPC();
            this.pcexprs.add(new PCExpr((Expr)e, pc, toPC));
        }
    }

    @Override
    public String getType() {
        return null;
    }

    public boolean endsWithTransfer() {
        if (this.exprs.length == 0) {
            return false;
        }
        return IfExpr.isTransfer(this.exprs[this.exprs.length - 1]);
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        boolean needBraces;
        if (this.exprs.length == 0) {
            return;
        }
        if (this.exprs.length == 1) {
            ((Expr)this.exprs[0]).asSource(sb, lnt, ind, false);
            return;
        }
        boolean bl = needBraces = this.pcexprs.get((int)0).from > 0;
        if (needBraces) {
            sb.append(Justification.LEFT.format("", ind));
            sb.append("{\n");
            lnt.advance(1);
        }
        for (PCExpr e : this.pcexprs) {
            lnt.add(e.from);
            e.expr.asSource(sb, lnt, ind + 2, false);
        }
        if (needBraces) {
            sb.append(Justification.LEFT.format("", ind));
            sb.append("}\n");
            lnt.advance(1);
        }
    }
}

