/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.exceptions.NoSuchDirectoryException;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;
import org.zinutils.utils.ZUJarEntry;
import org.zinutils.utils.ZUJarFile;

public class BCEClassLoader
extends ClassLoader {
    static final Logger logger = LoggerFactory.getLogger((String)"BCEClassLoader");
    private final List<ByteCodeEnvironment> bces = new ArrayList<ByteCodeEnvironment>();
    private final List<File> paths = new ArrayList<File>();

    public BCEClassLoader(ByteCodeEnvironment bce) {
        super(BCEClassLoader.class.getClassLoader());
        if (bce != null) {
            this.bces.add(bce);
        }
    }

    public BCEClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void add(ByteCodeEnvironment bce) {
        this.bces.add(bce);
    }

    public void addClassesFrom(File file) {
        if (file == null || !file.exists()) {
            throw new NoSuchDirectoryException("There is no path " + file + " from which to add classes");
        }
        this.paths.add(file);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ByteCodeEnvironment bce : this.bces) {
            if (!bce.generatesClass(name)) continue;
            byte[] bs = bce.get(name).generate();
            return super.defineClass(name, bs, 0, bs.length);
        }
        String path = FileUtils.convertDottedToSlashPath(name) + ".class";
        for (File p : this.paths) {
            if (p.isDirectory()) {
                File cp = new File(p, path);
                if (!cp.isFile()) continue;
                byte[] bs = FileUtils.readFileAsBytes(cp);
                return super.defineClass(name, bs, 0, bs.length);
            }
            if (p.getName().endsWith(".jar")) {
                JarFile jf = null;
                try {
                    jf = new JarFile(p);
                    Enumeration<JarEntry> e = jf.entries();
                    while (e.hasMoreElements()) {
                        JarEntry elt = e.nextElement();
                        if (!elt.getName().equals(path)) continue;
                        byte[] bs = FileUtils.readAllStream(jf.getInputStream(elt));
                        Class<?> clazz = super.defineClass(name, bs, 0, bs.length);
                        return clazz;
                    }
                    continue;
                }
                catch (IOException ex) {
                    throw UtilException.wrap(ex);
                }
                finally {
                    if (jf == null) continue;
                    try {
                        jf.close();
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
            throw new UtilException("Path " + p + " is not a directory");
        }
        return super.findClass(name);
    }

    public <T> Iterable<T> services(Class<T> intf) {
        ArrayList ret = new ArrayList();
        for (File p : this.paths) {
            try (ZUJarFile jf = new ZUJarFile(p);){
                String[] clzs;
                ZUJarEntry svc = jf.get("META-INF/services/" + intf.getName());
                logger.info("loading services for " + intf + " from " + jf + ": file " + svc);
                if (svc == null) continue;
                for (String c : clzs = new String(FileUtils.readAllStream(jf.getInputStream(svc.getJava()))).split("\n")) {
                    logger.info("instantiating service class " + c);
                    Class<?> clz = Class.forName(c, false, this);
                    ret.add(clz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String toString() {
        return "BCEClassLoader" + this.paths + "#" + this.bces.size();
    }
}

