/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.bytecode.ConstPool;

public class AttributeInfo {
    private final ConstPool pool;
    final int nameIdx;
    private final byte[] bytes;

    public AttributeInfo(ConstPool pool, int nameIdx, byte[] bytes) {
        this.pool = pool;
        this.nameIdx = nameIdx;
        this.bytes = bytes;
    }

    public AttributeInfo(ByteCodeFile bcf, String attrClass, byte[] bytes) {
        this.pool = bcf.pool;
        this.nameIdx = this.pool.requireUtf8(attrClass);
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean hasName(String s) {
        return s.equals(((CPInfo.Utf8Info)this.pool.get(this.nameIdx)).asString());
    }

    public String toString() {
        return "AttrInfo[" + this.pool.get(this.nameIdx) + ":" + this.bytes.length + "]";
    }
}

