/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.FieldExpr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.Var;
import org.zinutils.utils.Justification;

public class AssignExpr
extends Expr {
    private final Var assignTo;
    private final IExpr field;
    private final IExpr expr;

    public AssignExpr(MethodDefiner meth, Var assignTo, IExpr expr) {
        super(meth);
        this.assignTo = assignTo;
        this.field = null;
        this.expr = expr;
    }

    public AssignExpr(MethodDefiner meth, IExpr field, IExpr expr) {
        super(meth);
        if (field instanceof Var) {
            this.assignTo = (Var)field;
            this.field = null;
        } else {
            this.assignTo = null;
            this.field = field;
        }
        this.expr = expr;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        if (this.field != null) {
            ((FieldExpr)this.field).prepare(meth);
        }
        this.expr.spitOutByteCode(meth);
        if (this.assignTo != null) {
            this.assignTo.store();
        } else {
            ((FieldExpr)this.field).put(meth);
        }
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        sb.append(Justification.LEFT.format("", ind));
        if (this.field != null) {
            this.field.asSource(sb, lnt, ind, true);
        } else if (this.assignTo != null) {
            this.assignTo.asSource(sb, lnt, ind, true);
        }
        sb.append(" = ");
        this.expr.asSource(sb, lnt, ind, true);
        sb.append("\n");
        lnt.advance(1);
    }

    @Override
    public String getType() {
        if (this.assignTo != null) {
            return this.assignTo.getType();
        }
        return this.field.getType();
    }
}

