/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.utils.Justification;

public class ArrayOfExpr
extends Expr {
    private final String clz;
    private final List<IExpr> al;

    public ArrayOfExpr(MethodDefiner meth, String clz, List<IExpr> al) {
        super(meth);
        this.clz = clz;
        for (IExpr e : al) {
            if (e != null) continue;
            throw new CantHappenException("cannot provide null IExpr");
        }
        this.al = new ArrayList<IExpr>(al);
    }

    public List<IExpr> arguments() {
        return this.al;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        meth.iconst(this.al.size());
        meth.anewarray(this.clz);
        int k = 0;
        for (IExpr e : this.al) {
            meth.dup();
            meth.iconst(k++);
            e.spitOutByteCode(meth);
            meth.aastore();
        }
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        if (!suppressFirst) {
            sb.append(Justification.LEFT.format("", ind));
            lnt.advance(1);
        }
        sb.append("new " + this.clz + "[" + this.al.size() + "] {");
        for (IExpr e : this.al) {
            sb.append("\n");
            sb.append(Justification.LEFT.format("", ind));
            lnt.advance(1);
            e.asSource(sb, lnt, ind + 2, true);
        }
        if (!this.al.isEmpty()) {
            sb.append("\n");
            sb.append(Justification.LEFT.format("", ind));
            lnt.advance(1);
        }
        sb.append("}");
    }

    @Override
    public String getType() {
        return "[" + this.clz;
    }
}

