/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.LineNumberTable;
import org.zinutils.bytecode.MethodCreator;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.exceptions.UtilException;

public class ArrayEltExpr
extends Expr {
    private final IExpr arr;
    private final IExpr elt;

    public ArrayEltExpr(MethodCreator meth, IExpr arr, IExpr elt) {
        super(meth);
        if (arr.getType().charAt(0) != '[') {
            throw new UtilException("I think this needs to be an array");
        }
        this.arr = arr;
        this.elt = elt;
    }

    @Override
    public void spitOutByteCode(MethodDefiner meth) {
        this.arr.spitOutByteCode(meth);
        this.elt.spitOutByteCode(meth);
        meth.aaload();
    }

    @Override
    public String getType() {
        return this.arr.getType().substring(1);
    }

    @Override
    public void asSource(StringBuilder sb, LineNumberTable lnt, int ind, boolean suppressFirst) {
        this.arr.asSource(sb, lnt, ind, false);
        sb.append("[");
        this.elt.asSource(sb, lnt, ind, false);
        sb.append("]");
        lnt.advance(1);
    }
}

