/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.AnnotationTag;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.exceptions.UtilException;

public class AnnotationValue {
    private final AnnotationTag tag;
    private final Object value;

    public AnnotationValue(AnnotationTag tag, Object value) {
        this.tag = tag;
        this.value = value;
    }

    public static AnnotationValue parse(ByteCodeFile bcf, DataInputStream dis) throws IOException {
        AnnotationTag tag = AnnotationTag.parse(dis);
        Object value = tag.parseValue(bcf, dis);
        return new AnnotationValue(tag, value);
    }

    public void write(ByteCodeFile bcf, DataOutputStream dos) throws IOException {
        this.tag.write(bcf, dos, this.value);
    }

    public String asString() {
        if (this.tag == AnnotationTag.TEXT) {
            return (String)this.value;
        }
        if (this.tag == AnnotationTag.ENUM) {
            return ((String[])this.value)[1];
        }
        throw new UtilException("Not a string");
    }

    public String asClassName() {
        if (this.tag != AnnotationTag.CLASS) {
            throw new UtilException("Not a class name");
        }
        return (String)this.value;
    }

    public <T extends Enum<T>> T asEnum(Class<T> en) {
        if (this.tag == AnnotationTag.ENUM) {
            return Enum.valueOf(en, this.asString());
        }
        throw new UtilException("Not an enum");
    }

    public String toString() {
        return this.tag + "." + this.value;
    }

    public AnnotationValue[] asArray() {
        if (!(this.value instanceof AnnotationValue[])) {
            throw new UtilException("The annotation value is not an array of annotations");
        }
        return (AnnotationValue[])this.value;
    }

    public boolean isString() {
        return this.tag == AnnotationTag.TEXT || this.tag == AnnotationTag.ENUM;
    }

    public boolean isArray() {
        return this.tag == AnnotationTag.ARRAY;
    }

    public Annotation asAnnotation() {
        if (!(this.value instanceof Annotation)) {
            throw new UtilException("The annotation value is not an annotation");
        }
        return (Annotation)this.value;
    }
}

