/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.AttributeInfo;
import org.zinutils.bytecode.ByteCodeFile;

public enum AnnotationType {
    RuntimeVisibleAnnotations,
    RuntimeInvisibleAnnotations,
    RuntimeVisibleParameterAnnotations;

    public static final Comparator<AnnotationType> sortOrder;

    public boolean isPerParameter() {
        return this == RuntimeVisibleParameterAnnotations;
    }

    public void addTo(ByteCodeFile bcf, List<AttributeInfo> attributes, List<Annotation> list, int paramCount) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        if (this.isPerParameter()) {
            dos.writeByte(paramCount);
            ArrayList lists = new ArrayList();
            for (int i = 0; i < paramCount; ++i) {
                lists.add(new ArrayList());
            }
            for (Annotation annotation : list) {
                ((List)lists.get(annotation.forParam())).add(annotation);
            }
            for (List list2 : lists) {
                this.writeAnnoList(dos, list2);
            }
        } else {
            this.writeAnnoList(dos, list);
        }
        attributes.add(new AttributeInfo(bcf, this.toString(), baos.toByteArray()));
    }

    private void writeAnnoList(DataOutputStream dos, List<Annotation> list) throws IOException {
        dos.writeShort(list.size());
        for (Annotation a : list) {
            a.write(dos);
        }
    }

    static {
        sortOrder = new Comparator<AnnotationType>(){

            @Override
            public int compare(AnnotationType o1, AnnotationType o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
    }
}

