/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.AnnotationValue;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.exceptions.UtilException;

public enum AnnotationTag {
    ANNOTATION,
    ARRAY,
    CLASS,
    ENUM,
    TEXT,
    BOOLEAN,
    INT;


    public void write(ByteCodeFile bcf, DataOutputStream dos, Object value) throws IOException {
        switch (this) {
            case ANNOTATION: {
                dos.writeByte(64);
                ((Annotation)value).write(dos);
                break;
            }
            case ARRAY: {
                dos.writeByte(91);
                AnnotationValue[] arr = (AnnotationValue[])value;
                dos.writeShort(arr.length);
                for (AnnotationValue aa : arr) {
                    aa.write(bcf, dos);
                }
                break;
            }
            case CLASS: {
                dos.writeByte(99);
                dos.writeShort(((Short)value).shortValue());
                break;
            }
            case ENUM: {
                dos.writeByte(101);
                String[] typeValue = (String[])value;
                dos.writeShort(bcf.pool.requireUtf8(JavaInfo.map(typeValue[0])));
                dos.writeShort(bcf.pool.requireUtf8(typeValue[1]));
                break;
            }
            case TEXT: {
                dos.writeByte(115);
                dos.writeShort(bcf.pool.requireUtf8((String)value));
                break;
            }
            case BOOLEAN: {
                dos.writeByte(90);
                dos.writeShort(bcf.pool.requireInteger((Boolean)value != false ? 1 : 0));
                break;
            }
            default: {
                throw new UtilException("Cannot handle " + this);
            }
        }
    }

    public static AnnotationTag parse(DataInputStream dis) throws IOException {
        char b = (char)dis.readByte();
        switch (b) {
            case '@': {
                return ANNOTATION;
            }
            case '[': {
                return ARRAY;
            }
            case 'c': {
                return CLASS;
            }
            case 'e': {
                return ENUM;
            }
            case 's': {
                return TEXT;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'I': {
                return INT;
            }
        }
        throw new UtilException("Cannot handle " + b);
    }

    public Object parseValue(ByteCodeFile bcf, DataInputStream dis) throws IOException {
        switch (this) {
            case ANNOTATION: {
                return Annotation.parseOne(bcf, dis);
            }
            case ARRAY: {
                int len = dis.readShort();
                AnnotationValue[] arr = new AnnotationValue[len];
                for (int i = 0; i < len; ++i) {
                    arr[i] = AnnotationValue.parse(bcf, dis);
                }
                return arr;
            }
            case CLASS: {
                return ((CPInfo.Utf8Info)bcf.pool.get(dis.readShort())).asString();
            }
            case ENUM: {
                String type = ((CPInfo.Utf8Info)bcf.pool.get(dis.readShort())).asString();
                String constant = ((CPInfo.Utf8Info)bcf.pool.get(dis.readShort())).asString();
                return new String[]{type, constant};
            }
            case TEXT: {
                return ((CPInfo.Utf8Info)bcf.pool.get(dis.readShort())).asString();
            }
            case BOOLEAN: {
                return ((CPInfo.IntegerInfo)bcf.pool.get(dis.readShort())).value() == 1;
            }
            case INT: {
                return ((CPInfo.IntegerInfo)bcf.pool.get(dis.readShort())).value();
            }
        }
        throw new UtilException("Cannot handle " + this);
    }
}

